/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.Traversal;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.core.NodeTypeRepresentationStrategy;
import org.springframework.data.persistence.EntityInstantiator;

public class SubReferenceNodeTypeRepresentationStrategy
implements NodeTypeRepresentationStrategy {
    private static final Log log = LogFactory.getLog(SubReferenceNodeTypeRepresentationStrategy.class);
    public static final RelationshipType INSTANCE_OF_RELATIONSHIP_TYPE = DynamicRelationshipType.withName((String)"INSTANCE_OF");
    public static final RelationshipType SUBCLASS_OF_RELATIONSHIP_TYPE = DynamicRelationshipType.withName((String)"SUBCLASS_OF");
    public static final String SUBREFERENCE_NODE_COUNTER_KEY = "count";
    public static final String SUBREF_PREFIX = "SUBREF_";
    public static final String SUBREF_CLASS_KEY = "class";
    private GraphDatabaseService graphDatabaseService;
    private EntityInstantiator<NodeBacked, Node> entityInstantiator;

    public SubReferenceNodeTypeRepresentationStrategy(GraphDatabaseService graphDatabaseService, EntityInstantiator<NodeBacked, Node> entityInstantiator) {
        this.graphDatabaseService = graphDatabaseService;
        this.entityInstantiator = entityInstantiator;
    }

    public static Node getSingleOtherNode(Node node, RelationshipType type, Direction direction) {
        Relationship rel = node.getSingleRelationship(type, direction);
        return rel == null ? null : rel.getOtherNode(node);
    }

    public static Integer incrementAndGetCounter(Node node, String propertyKey) {
        SubReferenceNodeTypeRepresentationStrategy.acquireWriteLock((PropertyContainer)node);
        int value = (Integer)node.getProperty(propertyKey, (Object)0);
        node.setProperty(propertyKey, (Object)(++value));
        return value;
    }

    public static Integer decrementAndGetCounter(Node node, String propertyKey, int notLowerThan) {
        int value = (Integer)node.getProperty(propertyKey, (Object)0);
        value = --value < notLowerThan ? notLowerThan : value;
        node.setProperty(propertyKey, (Object)value);
        return value;
    }

    public static void acquireWriteLock(PropertyContainer entity) {
        entity.removeProperty("___dummy_property_for_locking___");
    }

    @Override
    public void postEntityCreation(Node state, Class<? extends NodeBacked> type) {
        Node subReference = this.obtainSubreferenceNode(type);
        state.createRelationshipTo(subReference, INSTANCE_OF_RELATIONSHIP_TYPE);
        subReference.setProperty(SUBREF_CLASS_KEY, (Object)type.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created link to subref node: " + subReference + " with type: " + type.getName()));
        }
        SubReferenceNodeTypeRepresentationStrategy.incrementAndGetCounter(subReference, SUBREFERENCE_NODE_COUNTER_KEY);
        this.updateSuperClassSubrefs(type, subReference);
    }

    private void updateSuperClassSubrefs(Class<?> clazz, Node subReference) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            Node superClassSubref = this.obtainSubreferenceNode(superClass);
            if (SubReferenceNodeTypeRepresentationStrategy.getSingleOtherNode(subReference, SUBCLASS_OF_RELATIONSHIP_TYPE, Direction.OUTGOING) == null) {
                subReference.createRelationshipTo(superClassSubref, SUBCLASS_OF_RELATIONSHIP_TYPE);
            }
            superClassSubref.setProperty(SUBREF_CLASS_KEY, (Object)superClass.getName());
            Integer count = SubReferenceNodeTypeRepresentationStrategy.incrementAndGetCounter(superClassSubref, SUBREFERENCE_NODE_COUNTER_KEY);
            if (log.isDebugEnabled()) {
                log.debug((Object)("count on ref " + superClassSubref + " for class " + superClass.getSimpleName() + " = " + count));
            }
            this.updateSuperClassSubrefs(superClass, superClassSubref);
        }
    }

    @Override
    public long count(Class<? extends NodeBacked> entityClass) {
        Node subrefNode = this.findSubreferenceNode(entityClass);
        if (subrefNode == null) {
            return 0L;
        }
        return ((Integer)subrefNode.getProperty(SUBREFERENCE_NODE_COUNTER_KEY, (Object)0)).intValue();
    }

    @Override
    public <T extends NodeBacked> Class<T> getJavaType(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        Relationship instanceOfRelationship = node.getSingleRelationship(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
        if (instanceOfRelationship == null) {
            throw new IllegalArgumentException("The node " + node + " is not attached to a type hierarchy.");
        }
        Node subrefNode = instanceOfRelationship.getEndNode();
        try {
            Class<NodeBacked> clazz = Class.forName((String)subrefNode.getProperty(SUBREF_CLASS_KEY)).asSubclass(NodeBacked.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found class " + clazz.getSimpleName() + " for node: " + node));
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to get type for node: " + node, e);
        }
    }

    @Override
    public void preEntityRemoval(Node state) {
        Class clazz = this.getJavaType(state);
        if (clazz == null) {
            return;
        }
        Node subReference = this.obtainSubreferenceNode(clazz);
        Relationship instanceOf = state.getSingleRelationship(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
        instanceOf.delete();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed link to subref node: " + subReference + " with type: " + clazz.getName()));
        }
        TraversalDescription traversal = Traversal.description().depthFirst().relationships(SUBCLASS_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
        for (Node node : traversal.traverse(subReference).nodes()) {
            Integer count = (Integer)node.getProperty(SUBREFERENCE_NODE_COUNTER_KEY);
            Integer newCount = SubReferenceNodeTypeRepresentationStrategy.decrementAndGetCounter(node, SUBREFERENCE_NODE_COUNTER_KEY, 0);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("count on ref " + node + " was " + count + " new " + newCount));
        }
    }

    @Override
    public <T extends NodeBacked> ClosableIterable<T> findAll(Class<T> clazz) {
        Node subrefNode = this.findSubreferenceNode(clazz);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Subref: " + subrefNode));
        }
        Iterable relIterables = this.findEntityIterables(subrefNode);
        return new ClosableCombiningIterable(relIterables);
    }

    private <T extends NodeBacked> List<Iterable<T>> findEntityIterables(Node subrefNode) {
        if (subrefNode == null) {
            return Collections.emptyList();
        }
        LinkedList<Iterable<T>> result = new LinkedList<Iterable<T>>();
        for (Relationship relationship : subrefNode.getRelationships(SUBCLASS_OF_RELATIONSHIP_TYPE, Direction.INCOMING)) {
            result.addAll((Collection)this.findEntityIterables(relationship.getStartNode()));
        }
        IterableWrapper t = new IterableWrapper<T, Relationship>(subrefNode.getRelationships(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.INCOMING)){

            protected T underlyingObjectToObject(Relationship rel) {
                Node node = rel.getStartNode();
                NodeBacked entity = (NodeBacked)SubReferenceNodeTypeRepresentationStrategy.this.entityInstantiator.createEntityFromState((Object)node, SubReferenceNodeTypeRepresentationStrategy.this.getJavaType(node));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Converting node: " + node + " to entity: " + entity));
                }
                return entity;
            }
        };
        result.add((Iterable<T>)t);
        return result;
    }

    public Node obtainSubreferenceNode(Class<?> entityClass) {
        return this.getOrCreateSubReferenceNode((RelationshipType)this.subRefRelationshipType(entityClass));
    }

    public Node findSubreferenceNode(Class<? extends NodeBacked> entityClass) {
        Relationship subrefRelationship = this.graphDatabaseService.getReferenceNode().getSingleRelationship((RelationshipType)this.subRefRelationshipType(entityClass), Direction.OUTGOING);
        return subrefRelationship != null ? subrefRelationship.getEndNode() : null;
    }

    private DynamicRelationshipType subRefRelationshipType(Class<?> clazz) {
        return DynamicRelationshipType.withName((String)(SUBREF_PREFIX + clazz.getName()));
    }

    public Node getOrCreateSubReferenceNode(RelationshipType relType) {
        return this.getOrCreateSingleOtherNode(this.graphDatabaseService.getReferenceNode(), relType, Direction.OUTGOING);
    }

    private Node getOrCreateSingleOtherNode(Node fromNode, RelationshipType type, Direction direction) {
        Relationship singleRelationship = fromNode.getSingleRelationship(type, direction);
        if (singleRelationship != null) {
            return singleRelationship.getOtherNode(fromNode);
        }
        Node otherNode = this.graphDatabaseService.createNode();
        fromNode.createRelationshipTo(otherNode, type);
        return otherNode;
    }

    @Override
    public <U extends NodeBacked> U createEntity(Node state) {
        Class javaType = this.getJavaType(state);
        if (javaType == null) {
            throw new IllegalStateException("No type stored on node.");
        }
        return (U)((NodeBacked)this.entityInstantiator.createEntityFromState((Object)state, javaType));
    }

    @Override
    public <U extends NodeBacked> U createEntity(Node state, Class<U> type) {
        Class javaType = this.getJavaType(state);
        if (javaType == null) {
            throw new IllegalStateException("No type stored on node.");
        }
        if (type.isAssignableFrom(javaType)) {
            return (U)((NodeBacked)this.entityInstantiator.createEntityFromState((Object)state, javaType));
        }
        throw new IllegalArgumentException(String.format("Entity is not of type: %s (was %s)", type, javaType));
    }

    @Override
    public <U extends NodeBacked> U projectEntity(Node state, Class<U> type) {
        return (U)((NodeBacked)this.entityInstantiator.createEntityFromState((Object)state, type));
    }

    private static class ClosableCombiningIterable<T extends NodeBacked>
    extends CombiningIterable<T>
    implements ClosableIterable<T> {
        private final Iterable<Iterable<T>> relIterables;

        public ClosableCombiningIterable(Iterable<Iterable<T>> relIterables) {
            super(relIterables);
            this.relIterables = relIterables;
        }

        public void close() {
            for (Iterable<T> it : this.relIterables) {
                if (!(it instanceof ClosableIterable)) continue;
                ((ClosableIterable)it).close();
            }
        }
    }
}

