/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.query;

import java.util.Map;
import org.neo4j.cypher.commands.Query;
import org.neo4j.cypher.javacompat.CypherParser;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.QueryResult;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.support.query.QueryEngine;

public class CypherQueryEngine
implements QueryEngine<Map<String, Object>> {
    final ExecutionEngine executionEngine;
    private ResultConverter resultConverter;

    public CypherQueryEngine(GraphDatabaseService graphDatabaseService) {
        this(graphDatabaseService, new DefaultConverter());
    }

    public CypherQueryEngine(GraphDatabaseService graphDatabaseService, ResultConverter resultConverter) {
        this.resultConverter = resultConverter != null ? resultConverter : new DefaultConverter();
        this.executionEngine = new ExecutionEngine(graphDatabaseService);
    }

    @Override
    public QueryResult<Map<String, Object>> query(String statement, Map<String, Object> params) {
        try {
            String parametrizedQuery = QueryResultBuilder.replaceParams(statement, params);
            ExecutionResult result = this.parseAndExecuteQuery(parametrizedQuery);
            return new QueryResultBuilder<Map<String, Object>>((Iterable<Map<String, Object>>)result, this.resultConverter);
        }
        catch (Exception e) {
            throw new InvalidDataAccessResourceUsageException("Error executing statement " + statement, (Throwable)e);
        }
    }

    private ExecutionResult parseAndExecuteQuery(String statement) {
        try {
            CypherParser parser = new CypherParser();
            Query query = parser.parse(statement);
            return this.executionEngine.execute(query);
        }
        catch (Exception e) {
            throw new InvalidDataAccessResourceUsageException("Error executing statement " + statement, (Throwable)e);
        }
    }
}

