/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.node;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexManager;
import org.springframework.data.neo4j.support.GraphDatabaseContext;

public abstract class Neo4jHelper {
    public static void cleanDb(GraphDatabaseContext graphDatabaseContext) {
        Neo4jHelper.cleanDb(graphDatabaseContext.getGraphDatabaseService());
    }

    public static void cleanDb(GraphDatabaseService graphDatabaseService) {
        Transaction tx = graphDatabaseService.beginTx();
        try {
            Neo4jHelper.removeNodes(graphDatabaseService);
            Neo4jHelper.clearIndex(graphDatabaseService);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private static void removeNodes(GraphDatabaseService graphDatabaseService) {
        Node refNode = graphDatabaseService.getReferenceNode();
        for (Node node : graphDatabaseService.getAllNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                rel.delete();
            }
        }
        for (Node node : graphDatabaseService.getAllNodes()) {
            if (refNode.equals(node)) continue;
            node.delete();
        }
    }

    private static void clearIndex(GraphDatabaseService gds) {
        String ix;
        IndexManager indexManager = gds.index();
        String[] stringArray = indexManager.nodeIndexNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            ix = stringArray[n2];
            indexManager.forNodes(ix).delete();
            ++n2;
        }
        stringArray = indexManager.relationshipIndexNames();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            ix = stringArray[n2];
            indexManager.forRelationships(ix).delete();
            ++n2;
        }
    }
}

