/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.HashSet;
import java.util.Set;
import org.springframework.data.neo4j.mapping.Neo4JMappingContext;
import org.springframework.data.neo4j.repository.query.MatchClause;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CypherQuery {
    private final String TEMPLATE = "start %s match % where %";
    private final Neo4JMappingContext context;
    private final TypeInformation<?> rootType;
    private final Set<MatchClause> matchClauses;

    public CypherQuery(TypeInformation<?> rootType, Neo4JMappingContext context) {
        Assert.notNull(rootType);
        Assert.notNull((Object)((Object)context));
        this.rootType = rootType;
        this.context = context;
        this.matchClauses = new HashSet<MatchClause>();
    }

    public CypherQuery addRestriction(Part part) {
        this.matchClauses.add(new MatchClause(this.context, part.getProperty()));
        return this;
    }

    public String toString() {
        return String.format("start %s match % where %", "TODO", StringUtils.collectionToCommaDelimitedString(this.matchClauses), "TODO");
    }
}

