/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.NumericRangeQuery;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.NamedIndexRepository;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.stereotype.Repository;

@Repository
public abstract class AbstractGraphRepository<S extends PropertyContainer, T extends GraphBacked<S>>
implements GraphRepository<T>,
NamedIndexRepository<T> {
    public static final ClosableIterable EMPTY_CLOSABLE_ITERABLE = new ClosableIterable(){

        public void close() {
        }

        public Iterator<?> iterator() {
            return Collections.emptyList().iterator();
        }
    };
    protected final Class<T> clazz;
    protected final GraphDatabaseContext graphDatabaseContext;

    public AbstractGraphRepository(GraphDatabaseContext graphDatabaseContext, Class<T> clazz) {
        this.graphDatabaseContext = graphDatabaseContext;
        this.clazz = clazz;
    }

    @Override
    public long count() {
        return this.graphDatabaseContext.count(this.clazz);
    }

    @Override
    public ClosableIterable<T> findAll() {
        return this.graphDatabaseContext.findAll(this.clazz);
    }

    @Override
    public T findOne(Long id) {
        try {
            return this.createEntity(this.getById(id));
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    @Override
    public T findByPropertyValue(String property, Object value) {
        return this.findByPropertyValue(null, property, value);
    }

    @Override
    public T findByPropertyValue(String indexName, String property, Object value) {
        PropertyContainer result;
        block3: {
            try {
                result = (PropertyContainer)this.getIndexHits(indexName, property, value).getSingle();
                if (result != null) break block3;
            }
            catch (NotFoundException notFoundException) {
                return null;
            }
            return null;
        }
        return this.createEntity(result);
    }

    private IndexHits<S> getIndexHits(String indexName, String property, Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return this.getIndex(indexName).query(property, this.createInclusiveRangeQuery(property, number, number));
        }
        return this.getIndex(indexName).get(property, value);
    }

    protected Index<S> getIndex(String indexName) {
        return this.graphDatabaseContext.getIndex(this.clazz, indexName);
    }

    protected T createEntity(S node) {
        return this.graphDatabaseContext.createEntityFromState(node, this.clazz);
    }

    @Override
    public ClosableIterable<T> findAllByPropertyValue(final String indexName, final String property, final Object value) {
        return this.query(indexName, new Query<S>(){

            @Override
            public IndexHits<S> query(Index<S> index) {
                return AbstractGraphRepository.this.getIndexHits(indexName, property, value);
            }
        });
    }

    @Override
    public ClosableIterable<T> findAllByPropertyValue(String property, Object value) {
        return this.findAllByPropertyValue(null, property, value);
    }

    @Override
    public ClosableIterable<T> findAllByQuery(String key, Object query) {
        return this.findAllByQuery(null, key, query);
    }

    @Override
    public ClosableIterable<T> findAllByQuery(final String indexName, final String key, final Object query) {
        return this.query(indexName, new Query<S>(){

            @Override
            public IndexHits<S> query(Index<S> index) {
                return AbstractGraphRepository.this.getIndex(indexName).query(key, query);
            }
        });
    }

    private ClosableIterable<T> query(String indexName, Query<S> query) {
        try {
            IndexHits<S> indexHits = query.query(this.getIndex(indexName));
            if (indexHits == null) {
                return this.emptyClosableIterable();
            }
            return new IndexHitsWrapper(indexHits);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    private ClosableIterable<T> emptyClosableIterable() {
        return EMPTY_CLOSABLE_ITERABLE;
    }

    @Override
    public ClosableIterable<T> findAllByRange(String property, Number from, Number to) {
        return this.findAllByRange(null, property, from, to);
    }

    @Override
    public ClosableIterable<T> findAllByRange(String indexName, final String property, final Number from, final Number to) {
        return this.query(indexName, new Query<S>(){

            @Override
            public IndexHits<S> query(Index<S> index) {
                return index.query(property, AbstractGraphRepository.this.createInclusiveRangeQuery(property, from, to));
            }
        });
    }

    protected <T extends Number> NumericRangeQuery<T> createInclusiveRangeQuery(String property, Number from, Number to) {
        if (from instanceof Long) {
            return NumericRangeQuery.newLongRange((String)property, (Long)from.longValue(), (Long)to.longValue(), (boolean)true, (boolean)true);
        }
        if (from instanceof Integer) {
            return NumericRangeQuery.newIntRange((String)property, (Integer)from.intValue(), (Integer)to.intValue(), (boolean)true, (boolean)true);
        }
        if (from instanceof Double) {
            return NumericRangeQuery.newDoubleRange((String)property, (Double)from.doubleValue(), (Double)to.doubleValue(), (boolean)true, (boolean)true);
        }
        if (from instanceof Float) {
            return NumericRangeQuery.newFloatRange((String)property, (Float)Float.valueOf(from.floatValue()), (Float)Float.valueOf(to.floatValue()), (boolean)true, (boolean)true);
        }
        return NumericRangeQuery.newIntRange((String)property, (Integer)from.intValue(), (Integer)to.intValue(), (boolean)true, (boolean)true);
    }

    protected abstract S getById(long var1);

    @Override
    public boolean exists(Long id) {
        try {
            return this.getById(id) != null;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    @Override
    public void delete(T entity) {
        entity.remove();
    }

    @Override
    public void delete(Long id) {
        this.delete(this.findOne(id));
    }

    @Override
    public void delete(Iterable<? extends T> entities) {
        for (GraphBacked entity : entities) {
            entity.remove();
        }
    }

    @Override
    public void deleteAll() {
        this.delete((Iterable<? extends T>)this.findAll());
    }

    @Override
    public ClosableIterable<T> findAll(Sort sort) {
        return this.findAll();
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        int count = pageable.getPageSize();
        int offset = pageable.getOffset();
        ClosableIterable<T> foundEntities = this.findAll(pageable.getSort());
        Iterator iterator = foundEntities.iterator();
        PageImpl<T> page = this.extractPage(pageable, count, offset, iterator);
        foundEntities.close();
        return page;
    }

    private PageImpl<T> extractPage(Pageable pageable, int count, int offset, Iterator<T> iterator) {
        ArrayList result = new ArrayList(count);
        int total = this.subList(offset, count, iterator, result);
        if (iterator.hasNext()) {
            ++total;
        }
        return new PageImpl(result, pageable, (long)total);
    }

    private int subList(int skip, int limit, Iterator<T> source, List<T> list) {
        int count = 0;
        while (source.hasNext()) {
            ++count;
            GraphBacked t = (GraphBacked)source.next();
            if (skip > 0) {
                --skip;
            } else {
                list.add(t);
                --limit;
            }
            if (limit + skip == 0) break;
        }
        return count;
    }

    private class IndexHitsWrapper
    extends IterableWrapper<T, S>
    implements ClosableIterable<T> {
        private final IndexHits<S> indexHits;

        public IndexHitsWrapper(IndexHits<S> indexHits) {
            super(indexHits);
            this.indexHits = indexHits;
        }

        protected T underlyingObjectToObject(S result) {
            return AbstractGraphRepository.this.createEntity(result);
        }

        public void close() {
            this.indexHits.close();
        }
    }

    static interface Query<S extends PropertyContainer> {
        public IndexHits<S> query(Index<S> var1);
    }
}

