/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.annotation.GraphTraversal;
import org.springframework.data.neo4j.core.FieldTraversalDescriptionBuilder;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.GenericTypeExtractor;
import org.springframework.data.neo4j.support.node.Neo4jNodeBacking;

public class TraversalFieldAccessorFactory
implements FieldAccessorFactory<NodeBacked> {
    @Override
    public boolean accept(Field f) {
        GraphTraversal graphEntityTraversal = f.getAnnotation(GraphTraversal.class);
        return graphEntityTraversal != null && graphEntityTraversal.traversalBuilder() != FieldTraversalDescriptionBuilder.class && f.getType().equals(Iterable.class);
    }

    @Override
    public FieldAccessor<NodeBacked> forField(Field field) {
        return new TraversalFieldAccessor(field);
    }

    public static class TraversalFieldAccessor
    implements FieldAccessor<NodeBacked> {
        protected final Field field;
        private final FieldTraversalDescriptionBuilder fieldTraversalDescriptionBuilder;
        private Class<? extends NodeBacked> target;
        protected String[] params;

        public TraversalFieldAccessor(Field field) {
            this.field = field;
            GraphTraversal graphEntityTraversal = field.getAnnotation(GraphTraversal.class);
            this.target = this.resolveTarget(graphEntityTraversal, field);
            this.params = graphEntityTraversal.params();
            this.fieldTraversalDescriptionBuilder = this.createTraversalDescription(graphEntityTraversal);
        }

        private Class<? extends NodeBacked> resolveTarget(GraphTraversal graphTraversal, Field field) {
            if (!graphTraversal.elementClass().equals(Object.class)) {
                return graphTraversal.elementClass();
            }
            Class<?> result = GenericTypeExtractor.resolveFieldType(field);
            if (!NodeBacked.class.isAssignableFrom(result)) {
                throw new IllegalArgumentException("The target result type of the traversal is no node entity: " + field);
            }
            return result;
        }

        @Override
        public boolean isWriteable(NodeBacked nodeBacked) {
            return false;
        }

        @Override
        public Object setValue(NodeBacked nodeBacked, Object newVal) {
            throw new InvalidDataAccessApiUsageException("Cannot set readonly traversal description field " + this.field);
        }

        @Override
        public Object getValue(NodeBacked nodeBacked) {
            TraversalDescription traversalDescription = this.fieldTraversalDescriptionBuilder.build(nodeBacked, this.field, this.params);
            return DoReturn.doReturn(Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$findAllByTraversal(nodeBacked, this.target, traversalDescription));
        }

        private FieldTraversalDescriptionBuilder createTraversalDescription(GraphTraversal graphEntityTraversal) {
            try {
                Class<? extends FieldTraversalDescriptionBuilder> traversalDescriptionClass = graphEntityTraversal.traversalBuilder();
                Constructor<? extends FieldTraversalDescriptionBuilder> constructor = traversalDescriptionClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating TraversalDescription from " + this.field, e);
            }
        }
    }
}

