/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.GenericTypeExtractor;
import org.springframework.data.neo4j.support.node.Neo4jNodeBacking;

public class QueryFieldAccessorFactory
implements FieldAccessorFactory<NodeBacked> {
    @Override
    public boolean accept(Field f) {
        Query query = f.getAnnotation(Query.class);
        return query != null && !query.value().isEmpty();
    }

    @Override
    public FieldAccessor<NodeBacked> forField(Field field) {
        return new QueryFieldAccessor(field);
    }

    public static class QueryFieldAccessor
    implements FieldAccessor<NodeBacked> {
        protected final Field field;
        private final String query;
        private Class<?> target;
        protected String[] annotationParams;
        private boolean iterableResult;

        public QueryFieldAccessor(Field field) {
            this.field = field;
            Query query = field.getAnnotation(Query.class);
            this.annotationParams = query.params();
            if (this.annotationParams.length % 2 != 0) {
                throw new IllegalArgumentException("Number of parameters has to be even to construct a parameter map");
            }
            this.query = query.value();
            this.iterableResult = Iterable.class.isAssignableFrom(field.getType());
            this.target = this.resolveTarget(query, field);
        }

        private Class<?> resolveTarget(Query query, Field field) {
            if (!query.elementClass().equals(Object.class)) {
                return query.elementClass();
            }
            return GenericTypeExtractor.resolveFieldType(field);
        }

        @Override
        public boolean isWriteable(NodeBacked nodeBacked) {
            return false;
        }

        @Override
        public Object setValue(NodeBacked nodeBacked, Object newVal) {
            throw new InvalidDataAccessApiUsageException("Cannot set readonly query field " + this.field);
        }

        @Override
        public Object getValue(NodeBacked nodeBacked) {
            return DoReturn.doReturn(this.executeQuery(nodeBacked, this.query, this.createPlaceholderParams(nodeBacked)));
        }

        private Object executeQuery(NodeBacked nodeBacked, String queryString, Map<String, Object> params) {
            if (!this.iterableResult) {
                return Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$findByQuery(nodeBacked, queryString, this.target, params);
            }
            if (Map.class.isAssignableFrom(this.target)) {
                return Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$findAllByQuery(nodeBacked, queryString, params);
            }
            return Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$findAllByQuery(nodeBacked, queryString, this.target, params);
        }

        private Map<String, Object> createPlaceholderParams(NodeBacked nodeBacked) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("start", Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$getNodeId(nodeBacked));
            if (this.annotationParams.length == 0) {
                return params;
            }
            int i = 0;
            while (i < this.annotationParams.length) {
                params.put(this.annotationParams[i], this.annotationParams[i + 1]);
                i += 2;
            }
            return params;
        }
    }
}

