/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.fieldaccess.AbstractNodeRelationshipFieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.ManagedFieldAccessorSet;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.data.neo4j.support.node.Neo4jNodeBacking;

public class OneToNRelationshipEntityFieldAccessorFactory
implements FieldAccessorFactory<NodeBacked> {
    private GraphDatabaseContext graphDatabaseContext;

    public OneToNRelationshipEntityFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
        this.graphDatabaseContext = graphDatabaseContext;
    }

    @Override
    public boolean accept(Field f) {
        return Iterable.class.isAssignableFrom(f.getType()) && this.hasValidRelationshipAnnotation(f);
    }

    @Override
    public FieldAccessor<NodeBacked> forField(Field field) {
        RelatedToVia relEntityAnnotation = this.getRelationshipAnnotation(field);
        return new OneToNRelationshipEntityFieldAccessor((RelationshipType)this.typeFrom(relEntityAnnotation), this.dirFrom(relEntityAnnotation), this.targetFrom(relEntityAnnotation), this.graphDatabaseContext, field);
    }

    private boolean hasValidRelationshipAnnotation(Field field) {
        boolean hasElementClass;
        RelatedToVia relEntityAnnotation = this.getRelationshipAnnotation(field);
        if (relEntityAnnotation == null) {
            return false;
        }
        Class<? extends RelationshipBacked> elementClass = relEntityAnnotation.elementClass();
        boolean bl = hasElementClass = elementClass != null && !RelationshipBacked.class.equals(elementClass);
        if (!hasElementClass) {
            throw new InvalidDataAccessApiUsageException(String.format("Missing mandatory attribute @RelatedTo.elementClass for one-to-N relationship field %s in class: %s", field.getName(), field.getDeclaringClass().getName()));
        }
        return hasElementClass;
    }

    private RelatedToVia getRelationshipAnnotation(Field field) {
        return field.getAnnotation(RelatedToVia.class);
    }

    private Class<? extends RelationshipBacked> targetFrom(RelatedToVia relEntityAnnotation) {
        return relEntityAnnotation.elementClass();
    }

    private Direction dirFrom(RelatedToVia relEntityAnnotation) {
        return relEntityAnnotation.direction().toNeo4jDir();
    }

    private DynamicRelationshipType typeFrom(RelatedToVia relEntityAnnotation) {
        return DynamicRelationshipType.withName((String)relEntityAnnotation.type());
    }

    public static class OneToNRelationshipEntityFieldAccessor
    extends AbstractNodeRelationshipFieldAccessor<NodeBacked, Node, RelationshipBacked, Relationship> {
        public OneToNRelationshipEntityFieldAccessor(RelationshipType type, Direction direction, Class<? extends RelationshipBacked> elementClass, GraphDatabaseContext graphDatabaseContext, Field field) {
            super(elementClass, graphDatabaseContext, direction, type, field);
        }

        @Override
        public Object setValue(NodeBacked entity, Object newVal) {
            throw new InvalidDataAccessApiUsageException("Cannot set read-only relationship entity field.");
        }

        @Override
        public boolean isWriteable(NodeBacked nodeBacked) {
            return false;
        }

        @Override
        public Object getValue(NodeBacked entity) {
            this.checkUnderlyingNode(entity);
            Set<RelationshipBacked> result = this.createEntitySetFromRelationships(entity);
            return DoReturn.doReturn(new ManagedFieldAccessorSet(entity, result, this.field));
        }

        private Set<RelationshipBacked> createEntitySetFromRelationships(NodeBacked entity) {
            HashSet<RelationshipBacked> result = new HashSet<RelationshipBacked>();
            for (Relationship rel : this.getStatesFromEntity(entity)) {
                RelationshipBacked relationshipEntity = (RelationshipBacked)this.graphDatabaseContext.createEntityFromState(rel, this.relatedType);
                result.add(relationshipEntity);
            }
            return result;
        }

        @Override
        protected Iterable<Relationship> getStatesFromEntity(NodeBacked entity) {
            return Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$getPersistentState(entity).getRelationships(this.type, this.direction);
        }

        @Override
        protected Relationship obtainSingleRelationship(Node start, Relationship end) {
            return null;
        }

        @Override
        protected Node getState(NodeBacked nodeBacked) {
            return Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$getPersistentState(nodeBacked);
        }
    }
}

