/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.support.GenericTypeExtractor;
import org.springframework.data.neo4j.support.GraphDatabaseContext;

public abstract class NodeRelationshipFieldAccessorFactory
implements FieldAccessorFactory<NodeBacked> {
    protected GraphDatabaseContext graphDatabaseContext;

    public NodeRelationshipFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
        this.graphDatabaseContext = graphDatabaseContext;
    }

    protected Class<? extends NodeBacked> targetFrom(Field field, RelatedTo relatedTo) {
        if (relatedTo != null && relatedTo.elementClass() != NodeBacked.class) {
            return relatedTo.elementClass();
        }
        return GenericTypeExtractor.resolveFieldType(field);
    }

    protected Direction dirFrom(RelatedTo relAnnotation) {
        return relAnnotation.direction().toNeo4jDir();
    }

    protected DynamicRelationshipType typeFrom(Field field) {
        return DynamicRelationshipType.withName((String)DelegatingFieldAccessorFactory.getNeo4jPropertyName(field));
    }

    protected DynamicRelationshipType typeFrom(RelatedTo relAnnotation) {
        return DynamicRelationshipType.withName((String)relAnnotation.type());
    }

    protected DynamicRelationshipType typeFrom(Field field, RelatedTo relAnnotation) {
        return "".equals(relAnnotation.type()) ? this.typeFrom(field) : this.typeFrom(relAnnotation);
    }

    protected RelatedTo getRelationshipAnnotation(Field field) {
        return field.getAnnotation(RelatedTo.class);
    }

    protected boolean hasValidRelationshipAnnotation(Field field) {
        RelatedTo relAnnotation = this.getRelationshipAnnotation(field);
        return relAnnotation != null;
    }
}

