/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryProviders;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.util.ReflectionUtils;

public abstract class DelegatingFieldAccessorFactory<T>
implements FieldAccessorFactory<T> {
    private static final Log log = LogFactory.getLog(DelegatingFieldAccessorFactory.class);
    protected final GraphDatabaseContext graphDatabaseContext;
    final Collection<FieldAccessorFactory<?>> fieldAccessorFactories = new ArrayList();
    final Collection<FieldAccessorListenerFactory<?>> fieldAccessorListenerFactories = new ArrayList();
    private final Map<Class<?>, FieldAccessorFactoryProviders> accessorFactoryProviderCache = new HashMap();

    protected abstract Collection<FieldAccessorListenerFactory<?>> createListenerFactories();

    protected abstract Collection<? extends FieldAccessorFactory<?>> createAccessorFactories();

    public DelegatingFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
        this.graphDatabaseContext = graphDatabaseContext;
        this.fieldAccessorFactories.addAll(this.createAccessorFactories());
        this.fieldAccessorListenerFactories.addAll(this.createListenerFactories());
    }

    public GraphDatabaseContext getGraphDatabaseContext() {
        return this.graphDatabaseContext;
    }

    @Override
    public boolean accept(Field f) {
        return true;
    }

    @Override
    public FieldAccessor forField(Field field) {
        FieldAccessorFactory factory = this.factoryForField(field);
        return factory != null ? factory.forField(field) : null;
    }

    private <E> FieldAccessorFactory<E> factoryForField(Field field) {
        if (this.isSyntheticField(field)) {
            return null;
        }
        for (FieldAccessorFactory<?> fieldAccessorFactory : this.fieldAccessorFactories) {
            if (!fieldAccessorFactory.accept(field)) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Factory " + fieldAccessorFactory + " used for field: " + field));
            }
            return fieldAccessorFactory;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("No FieldAccessor configured for field: " + field));
        }
        return null;
    }

    private boolean isSyntheticField(Field field) {
        return field.getName().contains("$");
    }

    public static String getNeo4jPropertyName(Field field) {
        Class<?> entityClass = field.getDeclaringClass();
        if (DelegatingFieldAccessorFactory.useShortNames(entityClass)) {
            return field.getName();
        }
        return String.format("%s.%s", entityClass.getSimpleName(), field.getName());
    }

    private static boolean useShortNames(Class<?> entityClass) {
        NodeEntity graphEntity = entityClass.getAnnotation(NodeEntity.class);
        if (graphEntity != null) {
            return graphEntity.useShortNames();
        }
        RelationshipEntity graphRelationship = entityClass.getAnnotation(RelationshipEntity.class);
        if (graphRelationship != null) {
            return graphRelationship.useShortNames();
        }
        return false;
    }

    public List<FieldAccessListener<T, ?>> listenersFor(Field field) {
        ArrayList result = new ArrayList();
        List fieldAccessListenerFactories = this.getFieldAccessListenerFactories(field);
        for (FieldAccessorListenerFactory fieldAccessorListenerFactory : fieldAccessListenerFactories) {
            FieldAccessListener listener = fieldAccessorListenerFactory.forField(field);
            result.add(listener);
        }
        return result;
    }

    private <E> List<FieldAccessorListenerFactory<E>> getFieldAccessListenerFactories(Field field) {
        ArrayList result = new ArrayList();
        for (FieldAccessorListenerFactory<?> fieldAccessorListenerFactory : this.fieldAccessorListenerFactories) {
            if (!fieldAccessorListenerFactory.accept(field)) continue;
            result.add(fieldAccessorListenerFactory);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> FieldAccessorFactoryProviders<T> accessorFactoriesFor(Class<T> type) {
        DelegatingFieldAccessorFactory delegatingFieldAccessorFactory = this;
        synchronized (delegatingFieldAccessorFactory) {
            FieldAccessorFactoryProviders fieldAccessorFactoryProviders = this.accessorFactoryProviderCache.get(type);
            if (fieldAccessorFactoryProviders != null) {
                return fieldAccessorFactoryProviders;
            }
            final FieldAccessorFactoryProviders<T> newFieldAccessorFactories = new FieldAccessorFactoryProviders<T>(type);
            ReflectionUtils.doWithFields(type, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    FieldAccessorFactory factory = DelegatingFieldAccessorFactory.this.factoryForField(field);
                    List listenerFactories = DelegatingFieldAccessorFactory.this.getFieldAccessListenerFactories(field);
                    newFieldAccessorFactories.add(field, factory, listenerFactories);
                }
            });
            this.accessorFactoryProviderCache.put(type, newFieldAccessorFactories);
            return newFieldAccessorFactories;
        }
    }
}

