/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.support;

import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.graph.core.GraphBacked;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.core.NodeTypeRepresentationStrategy;
import org.springframework.data.graph.core.RelationshipBacked;
import org.springframework.data.graph.core.RelationshipTypeRepresentationStrategy;
import org.springframework.data.graph.core.TypeRepresentationStrategy;
import org.springframework.data.graph.neo4j.annotation.Indexed;
import org.springframework.data.graph.neo4j.support.node.Neo4jNodeBacking;
import org.springframework.data.graph.neo4j.support.relationship.Neo4jRelationshipBacking;

public class GraphDatabaseContext {
    private static final Log log = LogFactory.getLog(GraphDatabaseContext.class);
    public static final String DEFAULT_NODE_INDEX_NAME = "node";
    public static final String DEFAULT_RELATIONSHIP_INDEX_NAME = "relationship";
    private GraphDatabaseService graphDatabaseService;
    private ConversionService conversionService;
    private Validator validator;
    private NodeTypeRepresentationStrategy nodeTypeRepresentationStrategy;
    private RelationshipTypeRepresentationStrategy relationshipTypeRepresentationStrategy;

    public <S extends PropertyContainer, T extends GraphBacked<S>> Index<S> getIndex(Class<T> type) {
        return this.getIndex(type, null);
    }

    public <S extends PropertyContainer, T extends GraphBacked<S>> Index<S> getIndex(Class<T> type, String indexName) {
        return this.getIndex(type, indexName, false);
    }

    public <S extends PropertyContainer, T extends GraphBacked<S>> Index<S> getIndex(Class<T> type, String indexName, boolean fullText) {
        Map config;
        if (indexName == null) {
            indexName = Indexed.Name.get(type);
        }
        Map map = config = fullText ? LuceneIndexImplementation.FULLTEXT_CONFIG : null;
        if (NodeBacked.class.isAssignableFrom(type)) {
            return this.getIndexManager().forNodes(indexName, config);
        }
        if (RelationshipBacked.class.isAssignableFrom(type)) {
            return this.getIndexManager().forRelationships(indexName, config);
        }
        throw new IllegalArgumentException("Wrong index type supplied: " + type);
    }

    public boolean transactionIsRunning() {
        if (!(this.graphDatabaseService instanceof AbstractGraphDatabase)) {
            return true;
        }
        try {
            TransactionManager txManager = ((AbstractGraphDatabase)this.graphDatabaseService).getConfig().getTxModule().getTxManager();
            return txManager.getStatus() != 6;
        }
        catch (SystemException e) {
            log.error((Object)"Error accessing TransactionManager", (Throwable)e);
            return false;
        }
    }

    public <T extends GraphBacked<? extends PropertyContainer>> ClosableIterable<T> findAll(Class<T> entityClass) {
        return this.getTypeRepresentationStrategy((PropertyContainer)entityClass).findAll(entityClass);
    }

    public <T extends GraphBacked<? extends PropertyContainer>> long count(Class<T> entityClass) {
        return this.getTypeRepresentationStrategy((PropertyContainer)entityClass).count(entityClass);
    }

    public <S extends PropertyContainer, T extends GraphBacked<S>> T createEntityFromStoredType(S state) {
        return (T)this.getTypeRepresentationStrategy(state).createEntity(state);
    }

    public <S extends PropertyContainer, T extends GraphBacked<S>> T createEntityFromState(S state, Class<T> type) {
        if (state == null) {
            throw new IllegalArgumentException("state has to be either a Node or Relationship, not null");
        }
        return this.getTypeRepresentationStrategy(state, type).createEntity(state, type);
    }

    public <S extends PropertyContainer, T extends GraphBacked<S>> T projectTo(GraphBacked<S> entity, Class<T> targetType) {
        PropertyContainer state = (PropertyContainer)entity.getPersistentState();
        return this.getTypeRepresentationStrategy(state, targetType).projectEntity(state, targetType);
    }

    public <S extends PropertyContainer, T extends GraphBacked<S>> void postEntityCreation(S node, Class<T> entityClass) {
        this.getTypeRepresentationStrategy(node, entityClass).postEntityCreation(node, entityClass);
    }

    public void removeNodeEntity(NodeBacked entity) {
        Node node = Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_graph_core_NodeBacked$getPersistentState(entity);
        if (node == null) {
            return;
        }
        this.nodeTypeRepresentationStrategy.preEntityRemoval(node);
        for (Relationship relationship : node.getRelationships()) {
            this.removeRelationship(relationship);
        }
        this.removeFromIndexes(node);
        node.delete();
    }

    public void removeRelationshipEntity(RelationshipBacked entity) {
        Relationship relationship = Neo4jRelationshipBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_relationship_Neo4jRelationshipBacking$org_springframework_data_graph_core_RelationshipBacked$getPersistentState(entity);
        if (relationship == null) {
            return;
        }
        this.removeRelationship(relationship);
    }

    private void removeRelationship(Relationship relationship) {
        this.relationshipTypeRepresentationStrategy.preEntityRemoval(relationship);
        this.removeFromIndexes(relationship);
        relationship.delete();
    }

    private void removeFromIndexes(Node node) {
        IndexManager indexManager = this.getIndexManager();
        String[] stringArray = indexManager.nodeIndexNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String indexName = stringArray[n2];
            indexManager.forNodes(indexName).remove((PropertyContainer)node);
            ++n2;
        }
    }

    private void removeFromIndexes(Relationship relationship) {
        IndexManager indexManager = this.getIndexManager();
        String[] stringArray = indexManager.relationshipIndexNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String indexName = stringArray[n2];
            indexManager.forRelationships(indexName).remove((PropertyContainer)relationship);
            ++n2;
        }
    }

    private IndexManager getIndexManager() {
        return this.graphDatabaseService.index();
    }

    private <T extends GraphBacked<? extends PropertyContainer>> TypeRepresentationStrategy<?, T> getTypeRepresentationStrategy(Class<T> type) {
        if (NodeBacked.class.isAssignableFrom(type)) {
            return this.nodeTypeRepresentationStrategy;
        }
        if (RelationshipBacked.class.isAssignableFrom(type)) {
            return this.relationshipTypeRepresentationStrategy;
        }
        throw new IllegalArgumentException("Type is not NodeBacked nor RelationshipBacked.");
    }

    private <S extends PropertyContainer, T extends GraphBacked<S>> TypeRepresentationStrategy<S, T> getTypeRepresentationStrategy(S state, Class<T> type) {
        if (state instanceof Node && NodeBacked.class.isAssignableFrom(type)) {
            return this.nodeTypeRepresentationStrategy;
        }
        if (state instanceof Relationship && RelationshipBacked.class.isAssignableFrom(type)) {
            return this.relationshipTypeRepresentationStrategy;
        }
        throw new IllegalArgumentException("Type is not NodeBacked nor RelationshipBacked.");
    }

    private <S extends PropertyContainer, T extends GraphBacked<S>> TypeRepresentationStrategy<S, T> getTypeRepresentationStrategy(S state) {
        if (state instanceof Node) {
            return this.nodeTypeRepresentationStrategy;
        }
        if (state instanceof Relationship) {
            return this.relationshipTypeRepresentationStrategy;
        }
        throw new IllegalArgumentException("Type is not NodeBacked nor RelationshipBacked.");
    }

    public Node createNode() {
        return this.graphDatabaseService.createNode();
    }

    public Node getNodeById(long nodeId) {
        return this.graphDatabaseService.getNodeById(nodeId);
    }

    public Node getReferenceNode() {
        return this.graphDatabaseService.getReferenceNode();
    }

    public Iterable<? extends Node> getAllNodes() {
        return this.graphDatabaseService.getAllNodes();
    }

    public Transaction beginTx() {
        return this.graphDatabaseService.beginTx();
    }

    public Relationship getRelationshipById(long id) {
        return this.graphDatabaseService.getRelationshipById(id);
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    public void setGraphDatabaseService(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy() {
        return this.nodeTypeRepresentationStrategy;
    }

    public void setNodeTypeRepresentationStrategy(NodeTypeRepresentationStrategy nodeTypeRepresentationStrategy) {
        this.nodeTypeRepresentationStrategy = nodeTypeRepresentationStrategy;
    }

    public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy() {
        return this.relationshipTypeRepresentationStrategy;
    }

    public void setRelationshipTypeRepresentationStrategy(RelationshipTypeRepresentationStrategy relationshipTypeRepresentationStrategy) {
        this.relationshipTypeRepresentationStrategy = relationshipTypeRepresentationStrategy;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validatorFactory) {
        this.validator = validatorFactory;
    }
}

