/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.support;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.kernel.Traversal;
import org.springframework.data.graph.core.GraphDatabase;
import org.springframework.data.graph.core.Property;

public class DelegatingGraphDatabase
implements GraphDatabase {
    protected GraphDatabaseService delegate;

    public DelegatingGraphDatabase(GraphDatabaseService delegate) {
        this.delegate = delegate;
    }

    @Override
    public Node getReferenceNode() {
        return this.delegate.getReferenceNode();
    }

    @Override
    public Node getNodeById(long id) {
        return this.delegate.getNodeById(id);
    }

    @Override
    public Node createNode(Property ... props) {
        return this.setProperties(this.delegate.createNode(), props);
    }

    private <T extends PropertyContainer> T setProperties(T primitive, Property ... properties) {
        assert (primitive != null);
        if (properties == null || properties.length == 0) {
            return primitive;
        }
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            if (prop.value == null) {
                primitive.removeProperty(prop.name);
            } else {
                primitive.setProperty(prop.name, prop.value);
            }
            ++n2;
        }
        return primitive;
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.delegate.getRelationshipById(id);
    }

    @Override
    public Relationship createRelationship(Node startNode, Node endNode, RelationshipType type, Property ... props) {
        return this.setProperties(startNode.createRelationshipTo(endNode, type), props);
    }

    @Override
    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        IndexManager indexManager = this.delegate.index();
        if (indexManager.existsForNodes(indexName)) {
            return indexManager.forNodes(indexName);
        }
        if (indexManager.existsForRelationships(indexName)) {
            return indexManager.forRelationships(indexName);
        }
        throw new IllegalArgumentException("Index " + indexName + " does not exist.");
    }

    @Override
    public <T extends PropertyContainer> Index<T> createIndex(Class<T> type, String indexName, boolean fullText) {
        IndexManager indexManager = this.delegate.index();
        if (this.isNode(type)) {
            if (indexManager.existsForNodes(indexName)) {
                return this.checkAndGetExistingIndex(indexName, fullText, indexManager.forNodes(indexName));
            }
            return indexManager.forNodes(indexName, this.indexConfigFor(fullText));
        }
        if (indexManager.existsForRelationships(indexName)) {
            return this.checkAndGetExistingIndex(indexName, fullText, (Index<T>)indexManager.forRelationships(indexName));
        }
        return indexManager.forRelationships(indexName, this.indexConfigFor(fullText));
    }

    public boolean isNode(Class<? extends PropertyContainer> type) {
        if (type.equals(Node.class)) {
            return true;
        }
        if (type.equals(Relationship.class)) {
            return false;
        }
        throw new IllegalArgumentException("Unknown Graph Primitive, neither Node nor Relationship" + type);
    }

    private <T extends PropertyContainer> Index<T> checkAndGetExistingIndex(String indexName, boolean fullText, Index<T> index) {
        Map existingConfig = this.delegate.index().getConfiguration(index);
        Map<String, String> config = this.indexConfigFor(fullText);
        if (config.equals(existingConfig)) {
            return index;
        }
        throw new IllegalArgumentException("Setup for index " + indexName + " does not match " + (fullText ? "fulltext" : "exact"));
    }

    private Map<String, String> indexConfigFor(boolean fullText) {
        return fullText ? LuceneIndexImplementation.FULLTEXT_CONFIG : LuceneIndexImplementation.EXACT_CONFIG;
    }

    @Override
    public TraversalDescription createTraversalDescription() {
        return Traversal.description();
    }

    public void shutdown() {
        this.delegate.shutdown();
    }
}

