/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.server;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Pair;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginLifecycle;
import org.springframework.context.ApplicationContext;
import org.springframework.data.graph.neo4j.server.ProvidedClassPathXmlApplicationContext;

public abstract class SpringPluginInitializer
implements PluginLifecycle {
    private String[] contextLocations;
    private Pair<String, Class>[] exposedBeans;
    protected ProvidedClassPathXmlApplicationContext ctx;

    public SpringPluginInitializer(String[] contextLocations, Pair<String, Class> ... exposedBeans) {
        this.contextLocations = contextLocations;
        this.exposedBeans = exposedBeans;
    }

    protected static Pair<String, Class> expose(String name, Class<?> type) {
        return Pair.of((Object)name, type);
    }

    public Collection<Injectable<?>> start(GraphDatabaseService graphDatabaseService, Configuration config) {
        this.ctx = new ProvidedClassPathXmlApplicationContext(graphDatabaseService, this.contextLocations);
        ArrayList result = new ArrayList(this.exposedBeans.length);
        ProvidedClassPathXmlApplicationContext appCtx = this.ctx;
        Pair<String, Class>[] pairArray = this.exposedBeans;
        int n = this.exposedBeans.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<String, Class> exposedBean = pairArray[n2];
            result.add(new SpringBeanInjectable((ApplicationContext)appCtx, (String)exposedBean.first(), (Class)exposedBean.other()));
            ++n2;
        }
        return result;
    }

    public void stop() {
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    private static class SpringBeanInjectable<T>
    implements Injectable<T> {
        private final String exposedBean;
        protected ApplicationContext ctx;
        private final Class<T> clazz;

        public SpringBeanInjectable(ApplicationContext ctx, String exposedBean, Class<T> clazz) {
            this.exposedBean = exposedBean;
            this.ctx = ctx;
            this.clazz = clazz;
        }

        public T getValue() {
            return (T)this.ctx.getBean(this.exposedBean);
        }

        public Class<T> getType() {
            return this.clazz;
        }
    }
}

