/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.repository;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.graph.annotation.NodeEntity;
import org.springframework.data.graph.annotation.RelationshipEntity;
import org.springframework.data.graph.neo4j.repository.GraphEntityInformation;
import org.springframework.data.graph.neo4j.repository.GraphMetamodelEntityInformation;
import org.springframework.data.graph.neo4j.repository.NodeGraphRepository;
import org.springframework.data.graph.neo4j.repository.RelationshipGraphRepository;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.support.EntityInformation;
import org.springframework.data.repository.support.RepositoryFactorySupport;
import org.springframework.data.repository.support.RepositoryMetadata;
import org.springframework.util.Assert;

public class GraphRepositoryFactory
extends RepositoryFactorySupport {
    private final GraphDatabaseContext graphDatabaseContext;

    public GraphRepositoryFactory(GraphDatabaseContext graphDatabaseContext) {
        Assert.notNull((Object)graphDatabaseContext);
        this.graphDatabaseContext = graphDatabaseContext;
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        return this.getTargetRepository(metadata, this.graphDatabaseContext);
    }

    protected Object getTargetRepository(RepositoryMetadata metadata, GraphDatabaseContext graphDatabaseContext) {
        metadata.getRepositoryInterface();
        Class type = metadata.getDomainClass();
        GraphEntityInformation entityInformation = (GraphEntityInformation)this.getEntityInformation(type);
        if (entityInformation.isNodeEntity()) {
            return new NodeGraphRepository(type, graphDatabaseContext);
        }
        return new RelationshipGraphRepository(type, graphDatabaseContext);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        Class domainClass = repositoryMetadata.getDomainClass();
        if (AnnotationUtils.findAnnotation((Class)domainClass, NodeEntity.class) != null) {
            return NodeGraphRepository.class;
        }
        if (AnnotationUtils.findAnnotation((Class)domainClass, RelationshipEntity.class) != null) {
            return RelationshipGraphRepository.class;
        }
        throw new IllegalArgumentException("Invalid Domain Class " + domainClass + " neither Node- nor RelationshipEntity");
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> type) {
        return new GraphMetamodelEntityInformation(type, this.graphDatabaseContext);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new QueryLookupStrategy(){

            public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata) {
                return null;
            }
        };
    }
}

