/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.repository;

import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.graph.annotation.NodeEntity;
import org.springframework.data.graph.core.GraphBacked;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.core.RelationshipBacked;
import org.springframework.data.graph.neo4j.repository.GraphEntityInformation;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;
import org.springframework.data.graph.neo4j.support.node.Neo4jNodeBacking;
import org.springframework.data.graph.neo4j.support.relationship.Neo4jRelationshipBacking;
import org.springframework.data.repository.support.AbstractEntityInformation;

public class GraphMetamodelEntityInformation<S extends PropertyContainer, T extends GraphBacked<S>>
extends AbstractEntityInformation<T, Long>
implements GraphEntityInformation<S, T> {
    private final boolean isNodeEntity;
    private final boolean isPartialEntity;
    private GraphDatabaseContext graphDatabaseContext;

    public GraphMetamodelEntityInformation(Class domainClass, GraphDatabaseContext graphDatabaseContext) {
        super(domainClass);
        this.graphDatabaseContext = graphDatabaseContext;
        NodeEntity nodeEntity = this.getJavaType().getAnnotation(NodeEntity.class);
        this.isNodeEntity = nodeEntity != null;
        this.isPartialEntity = this.isNodeEntity && nodeEntity.partial();
    }

    @Override
    public boolean isNodeEntity() {
        return this.isNodeEntity;
    }

    @Override
    public boolean isPartialEntity() {
        return this.isPartialEntity;
    }

    public boolean isNew(T entity) {
        return entity.hasPersistentState();
    }

    public Long getId(T entity) {
        return this.isNodeEntity() ? Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_graph_core_NodeBacked$getNodeId((NodeBacked)entity) : Neo4jRelationshipBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_relationship_Neo4jRelationshipBacking$org_springframework_data_graph_core_RelationshipBacked$getRelationshipId((RelationshipBacked)entity);
    }

    public Class<Long> getIdType() {
        return Long.class;
    }
}

