/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.graph.annotation.RelatedTo;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.graph.neo4j.fieldaccess.NodeRelationshipFieldAccessorFactory;
import org.springframework.data.graph.neo4j.fieldaccess.NodeToNodesRelationshipFieldAccessor;
import org.springframework.data.graph.neo4j.support.DoReturn;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;

public class OneToNRelationshipFieldAccessorFactory
extends NodeRelationshipFieldAccessorFactory {
    public OneToNRelationshipFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
        super(graphDatabaseContext);
    }

    @Override
    public boolean accept(Field f) {
        return Collection.class.isAssignableFrom(f.getType()) && this.hasValidRelationshipAnnotation(f);
    }

    @Override
    public FieldAccessor<NodeBacked> forField(Field field) {
        RelatedTo relAnnotation = this.getRelationshipAnnotation(field);
        return new OneToNRelationshipFieldAccessor((RelationshipType)this.typeFrom(field, relAnnotation), this.dirFrom(relAnnotation), this.targetFrom(relAnnotation), this.graphDatabaseContext, field);
    }

    public static class OneToNRelationshipFieldAccessor
    extends NodeToNodesRelationshipFieldAccessor<NodeBacked> {
        public OneToNRelationshipFieldAccessor(RelationshipType type, Direction direction, Class<? extends NodeBacked> elementClass, GraphDatabaseContext graphDatabaseContext, Field field) {
            super(elementClass, graphDatabaseContext, direction, type, field);
        }

        @Override
        public Object setValue(NodeBacked entity, Object newVal) {
            Node node = (Node)this.checkUnderlyingNode(entity);
            if (newVal == null) {
                this.removeMissingRelationships(node, Collections.<Node>emptySet());
                return null;
            }
            Set<Node> targetNodes = this.checkTargetIsSetOfNodebacked(newVal);
            this.checkNoCircularReference(node, targetNodes);
            this.removeMissingRelationships(node, targetNodes);
            this.createAddedRelationships(node, targetNodes);
            return this.createManagedSet(entity, (Set)newVal);
        }

        @Override
        public Object getValue(NodeBacked entity) {
            this.checkUnderlyingNode(entity);
            Set result = this.createEntitySetFromRelationshipEndNodes(entity);
            return DoReturn.doReturn(this.createManagedSet(entity, result));
        }
    }
}

