/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.fieldaccess;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.index.lucene.ValueContext;
import org.springframework.data.graph.core.GraphBacked;
import org.springframework.data.graph.neo4j.annotation.Indexed;
import org.springframework.data.graph.neo4j.fieldaccess.ConvertingNodePropertyFieldAccessorFactory;
import org.springframework.data.graph.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.graph.neo4j.fieldaccess.PropertyFieldAccessorFactory;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;

public class IndexingPropertyFieldAccessorListenerFactory<S extends PropertyContainer, T extends GraphBacked<S>>
implements FieldAccessorListenerFactory<T> {
    private final GraphDatabaseContext graphDatabaseContext;
    private final PropertyFieldAccessorFactory propertyFieldAccessorFactory;
    private final ConvertingNodePropertyFieldAccessorFactory convertingNodePropertyFieldAccessorFactory;

    public IndexingPropertyFieldAccessorListenerFactory(GraphDatabaseContext graphDatabaseContext, PropertyFieldAccessorFactory propertyFieldAccessorFactory, ConvertingNodePropertyFieldAccessorFactory convertingNodePropertyFieldAccessorFactory) {
        this.graphDatabaseContext = graphDatabaseContext;
        this.propertyFieldAccessorFactory = propertyFieldAccessorFactory;
        this.convertingNodePropertyFieldAccessorFactory = convertingNodePropertyFieldAccessorFactory;
    }

    @Override
    public boolean accept(Field f) {
        return this.isPropertyField(f) && this.isIndexed(f);
    }

    private boolean isIndexed(Field f) {
        Indexed indexedAnnotation = this.getIndexedAnnotation(f);
        return indexedAnnotation != null;
    }

    private boolean isPropertyField(Field f) {
        return this.propertyFieldAccessorFactory.accept(f) || this.convertingNodePropertyFieldAccessorFactory.accept(f);
    }

    @Override
    public FieldAccessListener<T, ?> forField(Field field) {
        Class<?> graphBacked = field.getDeclaringClass();
        Index<S> index = this.getIndex(field, graphBacked);
        String indexKey = this.getIndexKey(field);
        return new IndexingPropertyFieldAccessorListener<S>(index, indexKey);
    }

    private String getIndexKey(Field field) {
        Indexed indexed = this.getIndexedAnnotation(field);
        if (indexed == null || indexed.fieldName().isEmpty()) {
            return DelegatingFieldAccessorFactory.getNeo4jPropertyName(field);
        }
        return indexed.fieldName();
    }

    private Index<S> getIndex(Field field, Class<T> type) {
        if (!this.isFulltextIndex(field)) {
            return this.graphDatabaseContext.getIndex(type, Indexed.Name.get(field), false);
        }
        Indexed indexed = this.getIndexedAnnotation(field);
        if (indexed.indexName() == null) {
            throw new IllegalStateException("@Indexed(fullext=true) on " + field + " requires an indexName too ");
        }
        String defaultIndexName = Indexed.Name.getDefault(field);
        if (indexed.indexName().equals(defaultIndexName)) {
            throw new IllegalStateException("Full-index name for " + field + " must differ from the default name: " + defaultIndexName);
        }
        return this.graphDatabaseContext.getIndex(type, indexed.indexName(), true);
    }

    private boolean isFulltextIndex(Field field) {
        Indexed indexed = this.getIndexedAnnotation(field);
        return indexed != null && indexed.fulltext();
    }

    private Indexed getIndexedAnnotation(AnnotatedElement element) {
        return element.getAnnotation(Indexed.class);
    }

    public static class IndexingPropertyFieldAccessorListener<T extends PropertyContainer>
    implements FieldAccessListener<GraphBacked<T>, Object> {
        private static final Log log = LogFactory.getLog(IndexingPropertyFieldAccessorListener.class);
        protected final String indexKey;
        private final Index<T> index;

        public IndexingPropertyFieldAccessorListener(Index<T> index, String indexKey) {
            this.index = index;
            this.indexKey = indexKey;
        }

        @Override
        public void valueChanged(GraphBacked<T> graphBacked, Object oldVal, Object newVal) {
            if (newVal instanceof Number) {
                newVal = ValueContext.numeric((Number)((Number)newVal));
            }
            PropertyContainer state = (PropertyContainer)graphBacked.getPersistentState();
            if (newVal == null) {
                this.index.remove(state, this.indexKey);
            } else {
                this.index.add(state, this.indexKey, newVal);
            }
        }
    }
}

