/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.fieldaccess;

import java.lang.reflect.Field;
import javax.persistence.Id;
import org.springframework.data.graph.annotation.GraphId;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.graph.neo4j.support.DoReturn;
import org.springframework.data.graph.neo4j.support.node.Neo4jNodeBacking;

public class IdFieldAccessorFactory
implements FieldAccessorFactory<NodeBacked> {
    @Override
    public boolean accept(Field f) {
        return this.isIdField(f);
    }

    private boolean isIdField(Field field) {
        Class<?> type = field.getType();
        return !(!type.equals(Long.class) && !type.equals(Long.TYPE) || !field.isAnnotationPresent(GraphId.class) && !field.isAnnotationPresent(Id.class));
    }

    @Override
    public FieldAccessor<NodeBacked> forField(Field field) {
        return new IdFieldAccessor(field);
    }

    public static class IdFieldAccessor
    implements FieldAccessor<NodeBacked> {
        protected final Field field;

        public IdFieldAccessor(Field field) {
            this.field = field;
        }

        @Override
        public boolean isWriteable(NodeBacked nodeBacked) {
            return false;
        }

        @Override
        public Object setValue(NodeBacked nodeBacked, Object newVal) {
            return newVal;
        }

        @Override
        public Object getValue(NodeBacked nodeBacked) {
            return DoReturn.doReturn(Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_graph_core_NodeBacked$getPersistentState(nodeBacked).getId());
        }
    }
}

