/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import org.bson.types.ObjectId;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.repository.core.support.PersistentEntityInformation;

public class MappingMongoEntityInformation<T, ID>
extends PersistentEntityInformation<T, ID>
implements MongoEntityInformation<T, ID> {
    private final MongoPersistentEntity<T> entityMetadata;
    private final @Nullable String customCollectionName;
    private final Class<ID> fallbackIdType;

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity) {
        this(entity, null, null);
    }

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity, @Nullable Class<ID> fallbackIdType) {
        this(entity, null, fallbackIdType);
    }

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity, String customCollectionName) {
        this(entity, customCollectionName, null);
    }

    private MappingMongoEntityInformation(MongoPersistentEntity<T> entity, @Nullable String customCollectionName, @Nullable Class<ID> idType) {
        super(entity);
        this.entityMetadata = entity;
        this.customCollectionName = customCollectionName;
        this.fallbackIdType = idType != null ? idType : ObjectId.class;
    }

    @Override
    public String getCollectionName() {
        return this.customCollectionName == null ? this.entityMetadata.getCollection() : this.customCollectionName;
    }

    @Override
    public String getIdAttribute() {
        return this.entityMetadata.hasIdProperty() ? ((MongoPersistentProperty)this.entityMetadata.getRequiredIdProperty()).getName() : "_id";
    }

    public Class<ID> getIdType() {
        if (this.entityMetadata.hasIdProperty()) {
            return super.getIdType();
        }
        return this.fallbackIdType;
    }

    @Override
    public boolean isVersioned() {
        return this.entityMetadata.hasVersionProperty();
    }

    @Override
    public @Nullable Object getVersion(T entity) {
        if (!this.isVersioned()) {
            return null;
        }
        PersistentPropertyAccessor accessor = this.entityMetadata.getPropertyAccessor(entity);
        return accessor.getProperty(this.entityMetadata.getRequiredVersionProperty());
    }

    @Override
    public @Nullable Collation getCollation() {
        return this.entityMetadata.getCollation();
    }
}

