/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import java.util.List;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.util.Assert;

public class ExpressionTransformationContextSupport<T extends ExpressionNode> {
    private final T currentNode;
    private final @Nullable ExpressionNode parentNode;
    private final @Nullable Document previousOperationObject;

    public ExpressionTransformationContextSupport(T currentNode, @Nullable ExpressionNode parentNode, @Nullable Document previousOperationObject) {
        Assert.notNull(currentNode, (String)"currentNode must not be null");
        this.currentNode = currentNode;
        this.parentNode = parentNode;
        this.previousOperationObject = previousOperationObject;
    }

    public T getCurrentNode() {
        return this.currentNode;
    }

    public @Nullable ExpressionNode getParentNode() {
        return this.parentNode;
    }

    public @Nullable Document getPreviousOperationObject() {
        return this.previousOperationObject;
    }

    public boolean hasPreviousOperation() {
        return this.getPreviousOperationObject() != null;
    }

    public boolean parentIsSameOperation() {
        return this.parentNode != null && ((ExpressionNode)this.currentNode).isOfSameTypeAs(this.parentNode);
    }

    public Document addToPreviousOperation(@Nullable Object value) {
        Assert.state((this.previousOperationObject != null ? 1 : 0) != 0, (String)"No previous operation available");
        this.extractArgumentListFrom(this.previousOperationObject).add(value);
        return this.previousOperationObject;
    }

    public @Nullable Object addToPreviousOrReturn(@Nullable Object value) {
        return this.hasPreviousOperation() ? this.addToPreviousOperation(value) : value;
    }

    private List<Object> extractArgumentListFrom(Document context) {
        List l;
        Object o = context.get(context.keySet().iterator().next());
        return o instanceof List ? (l = (List)o) : List.of();
    }
}

