/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert.encryption;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.types.Binary;
import org.jspecify.annotations.Nullable;
import org.springframework.core.CollectionFactory;
import org.springframework.data.mongodb.core.convert.MongoConversionContext;
import org.springframework.data.mongodb.core.convert.encryption.EncryptingConverter;
import org.springframework.data.mongodb.core.convert.encryption.ExplicitEncryptionContext;
import org.springframework.data.mongodb.core.encryption.Encryption;
import org.springframework.data.mongodb.core.encryption.EncryptionContext;
import org.springframework.data.mongodb.core.encryption.EncryptionKey;
import org.springframework.data.mongodb.core.encryption.EncryptionKeyResolver;
import org.springframework.data.mongodb.core.encryption.EncryptionOptions;
import org.springframework.data.mongodb.core.mapping.Encrypted;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.Queryable;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoEncryptionConverter
implements EncryptingConverter<Object, Object> {
    private static final Log LOGGER = LogFactory.getLog(MongoEncryptionConverter.class);
    private static final List<String> RANGE_OPERATORS = Arrays.asList("$gt", "$gte", "$lt", "$lte");
    public static final String AND_OPERATOR = "$and";
    private final Encryption<BsonValue, BsonBinary> encryption;
    private final EncryptionKeyResolver keyResolver;

    public MongoEncryptionConverter(Encryption<BsonValue, BsonBinary> encryption, EncryptionKeyResolver keyResolver) {
        this.encryption = encryption;
        this.keyResolver = keyResolver;
    }

    @Override
    public @Nullable Object read(Object value, MongoConversionContext context) {
        Object object;
        Object decrypted = EncryptingConverter.super.read(value, context);
        if (decrypted instanceof BsonValue) {
            BsonValue bsonValue = (BsonValue)decrypted;
            object = BsonUtils.toJavaType(bsonValue);
        } else {
            object = decrypted;
        }
        return object;
    }

    @Override
    public @Nullable Object decrypt(Object encryptedValue, EncryptionContext context) {
        Object decryptedValue = encryptedValue;
        if (encryptedValue instanceof Binary || encryptedValue instanceof BsonBinary) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decrypting %s.%s.", this.getProperty(context).getOwner().getName(), this.getProperty(context).getName()));
            }
            if (encryptedValue == (decryptedValue = this.encryption.decrypt((BsonBinary)BsonUtils.simpleToBsonValue(encryptedValue)))) {
                return decryptedValue;
            }
        }
        MongoPersistentProperty persistentProperty = this.getProperty(context);
        if (this.getProperty(context).isCollectionLike() && decryptedValue instanceof Iterable) {
            Collection collection;
            int size;
            Iterable iterable = (Iterable)decryptedValue;
            if (iterable instanceof Collection) {
                Collection c = (Collection)iterable;
                v0 = c.size();
            } else {
                v0 = size = 10;
            }
            if (!persistentProperty.isEntity()) {
                collection = CollectionFactory.createCollection((Class)persistentProperty.getType(), (int)size);
                iterable.forEach(it -> {
                    if (it instanceof BsonValue) {
                        BsonValue bsonValue = (BsonValue)it;
                        collection.add(BsonUtils.toJavaType(bsonValue));
                    } else {
                        collection.add(context.read(it, persistentProperty.getActualType()));
                    }
                });
                return collection;
            }
            collection = CollectionFactory.createCollection((Class)persistentProperty.getType(), (int)size);
            iterable.forEach(it -> {
                if (it instanceof BsonValue) {
                    BsonValue bsonValue = (BsonValue)it;
                    collection.add(context.read(BsonUtils.toJavaType(bsonValue), persistentProperty.getActualType()));
                } else {
                    collection.add(context.read(it, persistentProperty.getActualType()));
                }
            });
            return collection;
        }
        if (!persistentProperty.isEntity() && persistentProperty.isMap() && persistentProperty.getType() != Document.class) {
            if (decryptedValue instanceof BsonValue) {
                BsonValue bsonValue = (BsonValue)decryptedValue;
                return new LinkedHashMap((Document)BsonUtils.toJavaType(bsonValue));
            }
            if (decryptedValue instanceof Document) {
                Document document = (Document)decryptedValue;
                return new LinkedHashMap(document);
            }
            if (decryptedValue instanceof Map) {
                Map map = (Map)decryptedValue;
                return map;
            }
        }
        if (persistentProperty.isEntity() && decryptedValue instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)decryptedValue;
            return context.read(BsonUtils.toJavaType((BsonValue)bsonDocument), persistentProperty.getTypeInformation().getType());
        }
        if (persistentProperty.isEntity() && decryptedValue instanceof Document) {
            Document document = (Document)decryptedValue;
            return context.read((Object)document, persistentProperty.getTypeInformation().getType());
        }
        return decryptedValue;
    }

    @Override
    public Object encrypt(@Nullable Object value, EncryptionContext context) {
        MongoPersistentProperty persistentProperty;
        Encrypted annotation;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Encrypting %s.%s.", this.getProperty(context).getOwner().getName(), this.getProperty(context).getName()));
        }
        if ((annotation = (Encrypted)(persistentProperty = this.getProperty(context)).findAnnotation(Encrypted.class)) == null) {
            annotation = (Encrypted)persistentProperty.getOwner().findAnnotation(Encrypted.class);
        }
        if (annotation == null) {
            throw new IllegalStateException(String.format("Property %s.%s is not annotated with @Encrypted", persistentProperty.getOwner().getName(), persistentProperty.getName()));
        }
        String algorithm = annotation.algorithm();
        EncryptionKey key = this.keyResolver.getKey(context);
        MongoConversionContext.OperatorContext operatorContext = context.getOperatorContext();
        EncryptionOptions encryptionOptions = new EncryptionOptions(algorithm, key, MongoEncryptionConverter.getEQOptions(persistentProperty, operatorContext));
        if (operatorContext != null && !operatorContext.isWriteOperation() && encryptionOptions.queryableEncryptionOptions() != null && !encryptionOptions.queryableEncryptionOptions().getQueryType().equals("equality")) {
            return this.encryptExpression(operatorContext, value, encryptionOptions);
        }
        return this.encryptValue(value, context, persistentProperty, encryptionOptions);
    }

    private static @Nullable EncryptionOptions.QueryableEncryptionOptions getEQOptions(MongoPersistentProperty persistentProperty, @Nullable MongoConversionContext.OperatorContext operatorContext) {
        boolean isPartOfARangeQuery;
        Queryable queryableAnnotation = (Queryable)persistentProperty.findAnnotation(Queryable.class);
        if (queryableAnnotation == null || !StringUtils.hasText((String)queryableAnnotation.queryType())) {
            return null;
        }
        EncryptionOptions.QueryableEncryptionOptions queryableEncryptionOptions = EncryptionOptions.QueryableEncryptionOptions.none();
        String queryAttributes = queryableAnnotation.queryAttributes();
        if (!queryAttributes.isEmpty()) {
            queryableEncryptionOptions = queryableEncryptionOptions.attributes((Map<String, Object>)Document.parse((String)queryAttributes));
        }
        if (queryableAnnotation.contentionFactor() >= 0L) {
            queryableEncryptionOptions = queryableEncryptionOptions.contentionFactor(queryableAnnotation.contentionFactor());
        }
        boolean bl = isPartOfARangeQuery = operatorContext != null && !operatorContext.isWriteOperation();
        if (isPartOfARangeQuery) {
            queryableEncryptionOptions = queryableEncryptionOptions.queryType(queryableAnnotation.queryType());
        }
        return queryableEncryptionOptions;
    }

    private BsonBinary encryptValue(Object value, EncryptionContext context, MongoPersistentProperty persistentProperty, EncryptionOptions encryptionOptions) {
        if (!persistentProperty.isEntity()) {
            Object convertedMap;
            if (persistentProperty.isCollectionLike()) {
                return this.encryption.encrypt(this.collectionLikeToBsonValue(value, persistentProperty, context), encryptionOptions);
            }
            if (persistentProperty.isMap() && (convertedMap = context.write(value)) instanceof Document) {
                Document document = (Document)convertedMap;
                return this.encryption.encrypt((BsonValue)document.toBsonDocument(), encryptionOptions);
            }
            return this.encryption.encrypt(BsonUtils.simpleToBsonValue(value), encryptionOptions);
        }
        if (persistentProperty.isCollectionLike()) {
            return this.encryption.encrypt(this.collectionLikeToBsonValue(value, persistentProperty, context), encryptionOptions);
        }
        Object write = context.write(value);
        if (write instanceof Document) {
            Document doc = (Document)write;
            return this.encryption.encrypt((BsonValue)doc.toBsonDocument(), encryptionOptions);
        }
        return this.encryption.encrypt(BsonUtils.simpleToBsonValue(write), encryptionOptions);
    }

    private BsonValue encryptExpression(MongoConversionContext.OperatorContext operatorContext, Object value, EncryptionOptions encryptionOptions) {
        BsonValue doc = BsonUtils.simpleToBsonValue(value);
        String fieldName = operatorContext.path();
        String queryOperator = operatorContext.operator();
        if (!RANGE_OPERATORS.contains(queryOperator)) {
            throw new AssertionError((Object)String.format("Not a valid range query. Querying a range encrypted field but the query operator '%s' for field path '%s' is not a range query.", queryOperator, fieldName));
        }
        BsonDocument encryptExpression = new BsonDocument(AND_OPERATOR, (BsonValue)new BsonArray(Collections.singletonList(new BsonDocument(fieldName, (BsonValue)new BsonDocument(queryOperator, doc)))));
        BsonDocument result = this.encryption.encryptExpression(encryptExpression, encryptionOptions);
        return result.getArray((Object)AND_OPERATOR).get(0).asDocument().getDocument((Object)fieldName).getBinary((Object)queryOperator);
    }

    private BsonValue collectionLikeToBsonValue(Object value, MongoPersistentProperty property, EncryptionContext context) {
        BsonArray bsonArray = new BsonArray();
        boolean isEntity = property.isEntity();
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            values.forEach(it -> {
                if (isEntity) {
                    Document document = (Document)context.write(it, property.getTypeInformation());
                    bsonArray.add((BsonValue)(document == null ? null : document.toBsonDocument()));
                } else {
                    bsonArray.add(BsonUtils.simpleToBsonValue(it));
                }
            });
        } else if (ObjectUtils.isArray((Object)value)) {
            for (Object o : ObjectUtils.toObjectArray((Object)value)) {
                if (isEntity) {
                    Document document = (Document)context.write(o, property.getTypeInformation());
                    bsonArray.add((BsonValue)(document == null ? null : document.toBsonDocument()));
                    continue;
                }
                bsonArray.add(BsonUtils.simpleToBsonValue(o));
            }
        }
        return bsonArray;
    }

    @Override
    public EncryptionContext buildEncryptionContext(MongoConversionContext context) {
        return new ExplicitEncryptionContext(context);
    }

    protected MongoPersistentProperty getProperty(EncryptionContext context) {
        return context.getProperty();
    }
}

