/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractReactiveMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryExecution;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.mongodb.repository.query.VectorSearchDelegate;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.spel.ExpressionDependencies;
import reactor.core.publisher.Mono;

public class ReactiveVectorSearchAggregation
extends AbstractReactiveMongoQuery {
    private final ReactiveMongoOperations mongoOperations;
    private final MongoPersistentEntity<?> collectionEntity;
    private final ValueExpressionDelegate valueExpressionDelegate;
    private final VectorSearchDelegate delegate;

    public ReactiveVectorSearchAggregation(ReactiveMongoQueryMethod method, ReactiveMongoOperations mongoOperations, ValueExpressionDelegate delegate) {
        super(method, mongoOperations, delegate);
        this.valueExpressionDelegate = delegate;
        if (!method.isSearchQuery() && !method.isCollectionQuery()) {
            throw new InvalidMongoDbApiUsageException(String.format("Repository Vector Search method '%s' must return either return SearchResults<T> or List<T> but was %s", method.getName(), method.getReturnType().getType().getSimpleName()));
        }
        this.mongoOperations = mongoOperations;
        this.collectionEntity = method.getEntityInformation().getCollectionEntity();
        this.delegate = new VectorSearchDelegate(method, mongoOperations.getConverter(), delegate);
    }

    @Override
    protected Publisher<Object> doExecute(ReactiveMongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        return this.getParameterBindingCodec().flatMapMany(codec -> {
            String json = this.delegate.getQueryString();
            ExpressionDependencies dependencies = codec.captureExpressionDependencies(json, accessor::getBindableValue, (ValueExpressionParser)this.valueExpressionDelegate);
            return this.getValueExpressionEvaluatorLater(dependencies, accessor).flatMapMany(expressionEvaluator -> {
                ParameterBindingContext bindingContext = new ParameterBindingContext(accessor::getBindableValue, (ValueExpressionEvaluator)expressionEvaluator);
                VectorSearchDelegate.QueryContainer query = this.delegate.createQuery((ValueExpressionEvaluator)expressionEvaluator, processor, accessor, typeToRead, (ParameterBindingDocumentCodec)codec, bindingContext);
                ReactiveMongoQueryExecution.VectorSearchExecution execution = new ReactiveMongoQueryExecution.VectorSearchExecution(this.mongoOperations, method, query);
                return execution.execute(query.query(), Document.class, this.collectionEntity.getCollection());
            });
        });
    }

    @Override
    protected Mono<Query> createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

