/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class SetWindowFieldsOperation
implements AggregationOperation,
FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private static final String CURRENT = "current";
    private static final String UNBOUNDED = "unbounded";
    private final @Nullable Object partitionBy;
    private final @Nullable AggregationOperation sortBy;
    private final WindowOutput output;

    protected SetWindowFieldsOperation(@Nullable Object partitionBy, @Nullable AggregationOperation sortBy, WindowOutput output) {
        this.partitionBy = partitionBy;
        this.sortBy = sortBy;
        this.output = output;
    }

    public static SetWindowFieldsOperationBuilder builder() {
        return new SetWindowFieldsOperationBuilder();
    }

    @Override
    public ExposedFields getFields() {
        return ExposedFields.synthetic(Fields.from(this.output.fields.toArray(new Field[0])));
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document $setWindowFields = new Document();
        if (this.partitionBy != null) {
            Object object = this.partitionBy;
            if (object instanceof AggregationExpression) {
                AggregationExpression aggregationExpression = (AggregationExpression)object;
                $setWindowFields.append("partitionBy", (Object)aggregationExpression.toDocument(context));
            } else {
                object = this.partitionBy;
                if (object instanceof Field) {
                    Field field = (Field)object;
                    $setWindowFields.append("partitionBy", (Object)context.getReference(field).toString());
                } else {
                    $setWindowFields.append("partitionBy", this.partitionBy);
                }
            }
        }
        if (this.sortBy != null) {
            $setWindowFields.append("sortBy", this.sortBy.toDocument(context).get((Object)this.sortBy.getOperator()));
        }
        Document output = new Document();
        for (ComputedField field : this.output.fields) {
            Document fieldOperation = field.getWindowOperator().toDocument(context);
            if (field.window != null) {
                fieldOperation.put("window", (Object)field.window.toDocument(context));
            }
            output.append(field.getName(), (Object)fieldOperation);
        }
        $setWindowFields.append("output", (Object)output);
        return new Document(this.getOperator(), (Object)$setWindowFields);
    }

    @Override
    public String getOperator() {
        return "$setWindowFields";
    }

    public static class WindowOutput {
        private final List<ComputedField> fields;

        public WindowOutput(ComputedField outputField) {
            Assert.notNull((Object)outputField, (String)"OutputField must not be null");
            this.fields = new ArrayList<ComputedField>();
            this.fields.add(outputField);
        }

        @Contract(value="_ -> this")
        public WindowOutput append(ComputedField field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            this.fields.add(field);
            return this;
        }

        @Contract(value="_ -> new")
        public ComputedFieldAppender append(final AggregationExpression expression) {
            return new ComputedFieldAppender(){
                private @Nullable Window window;
                final /* synthetic */ WindowOutput this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public WindowOutput as(String fieldname) {
                    return this.this$0.append(new ComputedField(fieldname, expression, this.window));
                }

                @Override
                public ComputedFieldAppender within(Window window) {
                    this.window = window;
                    return this;
                }
            };
        }

        public static interface ComputedFieldAppender {
            public WindowOutput as(String var1);

            public ComputedFieldAppender within(Window var1);
        }
    }

    public static class SetWindowFieldsOperationBuilder {
        private @Nullable Object partitionBy;
        private @Nullable SortOperation sortOperation;
        private @Nullable WindowOutput output;

        @Contract(value="_ -> this")
        public SetWindowFieldsOperationBuilder partitionByField(String fieldName) {
            Assert.hasText((String)fieldName, (String)"Field name must not be empty or null");
            return this.partitionBy(Fields.field("$" + fieldName, fieldName));
        }

        @Contract(value="_ -> this")
        public SetWindowFieldsOperationBuilder partitionByExpression(AggregationExpression expression) {
            return this.partitionBy(expression);
        }

        @Contract(value="_ -> this")
        public SetWindowFieldsOperationBuilder sortBy(String ... fields) {
            return this.sortBy(Sort.by((String[])fields));
        }

        @Contract(value="_ -> this")
        public SetWindowFieldsOperationBuilder sortBy(Sort sort) {
            return this.sortBy(new SortOperation(sort));
        }

        @Contract(value="_ -> this")
        public SetWindowFieldsOperationBuilder sortBy(SortOperation sort) {
            Assert.notNull((Object)sort, (String)"SortOperation must not be null");
            this.sortOperation = sort;
            return this;
        }

        @Contract(value="_ -> this")
        public SetWindowFieldsOperationBuilder output(WindowOutput output) {
            Assert.notNull((Object)output, (String)"WindowOutput must not be null");
            this.output = output;
            return this;
        }

        @Contract(value="_ -> new")
        public WindowChoice output(final AggregationExpression expression) {
            return new WindowChoice(){
                private @Nullable Window window;
                final /* synthetic */ SetWindowFieldsOperationBuilder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public As within(Window window) {
                    Assert.notNull((Object)window, (String)"Window must not be null");
                    this.window = window;
                    return this;
                }

                @Override
                public SetWindowFieldsOperationBuilder as(String targetFieldName) {
                    Assert.hasText((String)targetFieldName, (String)"Target field name must not be empty or null");
                    ComputedField computedField = new ComputedField(targetFieldName, expression, this.window);
                    if (this.this$0.output == null) {
                        this.this$0.output = new WindowOutput(computedField);
                    } else {
                        this.this$0.output.append(computedField);
                    }
                    return this.this$0;
                }
            };
        }

        @Contract(value="_ -> this")
        public SetWindowFieldsOperationBuilder partitionBy(Object value) {
            Assert.notNull((Object)value, (String)"Partition By must not be null");
            this.partitionBy = value;
            return this;
        }

        @Contract(value="-> new")
        public SetWindowFieldsOperation build() {
            Assert.notNull((Object)this.output, (String)"Output must be set first");
            return new SetWindowFieldsOperation(this.partitionBy, this.sortOperation, this.output);
        }

        public static interface WindowChoice
        extends As {
            public As within(Window var1);
        }

        public static interface As {
            public SetWindowFieldsOperationBuilder as(String var1);
        }
    }

    public static class ComputedField
    implements Field {
        private final String name;
        private final AggregationExpression windowOperator;
        private final @Nullable Window window;

        public ComputedField(String name, AggregationExpression windowOperator) {
            this(name, windowOperator, null);
        }

        public ComputedField(String name, AggregationExpression windowOperator, @Nullable Window window) {
            this.name = name;
            this.windowOperator = windowOperator;
            this.window = window;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTarget() {
            return this.getName();
        }

        @Override
        public boolean isAliased() {
            return false;
        }

        public AggregationExpression getWindowOperator() {
            return this.windowOperator;
        }

        public @Nullable Window getWindow() {
            return this.window;
        }
    }

    public static interface Window {
        public Object getLower();

        public Object getUpper();

        default public Document toDocument() {
            return this.toDocument(Aggregation.DEFAULT_CONTEXT);
        }

        public Document toDocument(AggregationOperationContext var1);
    }

    public static enum WindowUnits implements WindowUnit
    {
        DEFAULT,
        YEAR,
        QUARTER,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }

    public static interface WindowUnit {
        public String name();

        public static WindowUnit from(TimeUnit timeUnit) {
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
            return switch (timeUnit) {
                case TimeUnit.DAYS -> WindowUnits.DAY;
                case TimeUnit.HOURS -> WindowUnits.HOUR;
                case TimeUnit.MINUTES -> WindowUnits.MINUTE;
                case TimeUnit.SECONDS -> WindowUnits.SECOND;
                case TimeUnit.MILLISECONDS -> WindowUnits.MILLISECOND;
                default -> throw new IllegalArgumentException(String.format("Cannot create WindowUnit from %s", new Object[]{timeUnit}));
            };
        }

        public static WindowUnit from(ChronoUnit chronoUnit) {
            return switch (chronoUnit) {
                case ChronoUnit.YEARS -> WindowUnits.YEAR;
                case ChronoUnit.WEEKS -> WindowUnits.WEEK;
                case ChronoUnit.MONTHS -> WindowUnits.MONTH;
                case ChronoUnit.DAYS -> WindowUnits.DAY;
                case ChronoUnit.HOURS -> WindowUnits.HOUR;
                case ChronoUnit.MINUTES -> WindowUnits.MINUTE;
                case ChronoUnit.SECONDS -> WindowUnits.SECOND;
                case ChronoUnit.MILLIS -> WindowUnits.MILLISECOND;
                default -> throw new IllegalArgumentException(String.format("Cannot create WindowUnit from %s", chronoUnit));
            };
        }
    }

    public static class RangeWindow
    extends WindowImpl {
        private final WindowUnit unit;

        protected RangeWindow(Object lower, Object upper, WindowUnit unit) {
            super(lower, upper);
            this.unit = unit;
        }

        @Override
        public Document toDocument(AggregationOperationContext ctx) {
            Document range = new Document("range", (Object)new Object[]{this.getLower(), this.getUpper()});
            if (this.unit != null && !WindowUnits.DEFAULT.equals(this.unit)) {
                range.append("unit", (Object)this.unit.name().toLowerCase());
            }
            return range;
        }
    }

    public static class DocumentWindow
    extends WindowImpl {
        DocumentWindow(Object lower, Object upper) {
            super(lower, upper);
        }

        @Override
        public Document toDocument(AggregationOperationContext ctx) {
            return new Document("documents", Arrays.asList(this.getLower(), this.getUpper()));
        }
    }

    static abstract class WindowImpl
    implements Window {
        private final Object lower;
        private final Object upper;

        protected WindowImpl(Object lower, Object upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public Object getLower() {
            return this.lower;
        }

        @Override
        public Object getUpper() {
            return this.upper;
        }
    }

    public static class DocumentWindowBuilder {
        private @Nullable Object lower;
        private @Nullable Object upper;

        @Contract(value="_ -> this")
        public DocumentWindowBuilder from(Number lower) {
            this.lower = lower;
            return this;
        }

        @Contract(value="-> this")
        public DocumentWindowBuilder fromCurrent() {
            return this.from(SetWindowFieldsOperation.CURRENT);
        }

        @Contract(value="-> this")
        public DocumentWindowBuilder fromUnbounded() {
            return this.from(SetWindowFieldsOperation.UNBOUNDED);
        }

        @Contract(value="-> this")
        public DocumentWindowBuilder to(String upper) {
            this.upper = upper;
            return this;
        }

        @Contract(value="_ -> this")
        public DocumentWindowBuilder from(String lower) {
            this.lower = lower;
            return this;
        }

        @Contract(value="_ -> this")
        public DocumentWindowBuilder to(Number upper) {
            this.upper = upper;
            return this;
        }

        @Contract(value="-> this")
        public DocumentWindowBuilder toCurrent() {
            return this.to(SetWindowFieldsOperation.CURRENT);
        }

        @Contract(value="-> this")
        public DocumentWindowBuilder toUnbounded() {
            return this.to(SetWindowFieldsOperation.UNBOUNDED);
        }

        @Contract(value="-> new")
        public DocumentWindow build() {
            Assert.notNull((Object)this.lower, (String)"Lower bound must not be null");
            Assert.notNull((Object)this.upper, (String)"Upper bound must not be null");
            return new DocumentWindow(this.lower, this.upper);
        }
    }

    public static class RangeWindowBuilder {
        private @Nullable Object lower;
        private @Nullable Object upper;
        private @Nullable WindowUnit unit;

        @Contract(value="_ -> this")
        public RangeWindowBuilder from(String lower) {
            this.lower = lower;
            return this;
        }

        @Contract(value="_ -> this")
        public RangeWindowBuilder to(String upper) {
            this.upper = upper;
            return this;
        }

        @Contract(value="_ -> this")
        public RangeWindowBuilder from(Number lower) {
            this.lower = lower;
            return this;
        }

        @Contract(value="_ -> this")
        public RangeWindowBuilder to(Number upper) {
            this.upper = upper;
            return this;
        }

        @Contract(value="-> this")
        public RangeWindowBuilder fromCurrent() {
            return this.from(SetWindowFieldsOperation.CURRENT);
        }

        @Contract(value="-> this")
        public RangeWindowBuilder fromUnbounded() {
            return this.from(SetWindowFieldsOperation.UNBOUNDED);
        }

        @Contract(value="-> this")
        public RangeWindowBuilder toCurrent() {
            return this.to(SetWindowFieldsOperation.CURRENT);
        }

        @Contract(value="-> this")
        public RangeWindowBuilder toUnbounded() {
            return this.to(SetWindowFieldsOperation.UNBOUNDED);
        }

        @Contract(value="_ -> this")
        public RangeWindowBuilder unit(WindowUnit windowUnit) {
            Assert.notNull((Object)windowUnit, (String)"WindowUnit must not be null");
            this.unit = windowUnit;
            return this;
        }

        @Contract(value="-> new")
        public RangeWindow build() {
            Assert.notNull((Object)this.lower, (String)"Lower bound must not be null");
            Assert.notNull((Object)this.upper, (String)"Upper bound must not be null");
            Assert.notNull((Object)this.unit, (String)"WindowUnit bound must not be null");
            return new RangeWindow(this.lower, this.upper, this.unit);
        }
    }

    public static interface Windows {
        public static DocumentWindow documents(Object lower, Object upper) {
            return new DocumentWindow(lower, upper);
        }

        public static RangeWindow range(Object lower, Object upper, @Nullable WindowUnit unit) {
            return new RangeWindow(lower, upper, unit == null ? WindowUnits.DEFAULT : unit);
        }

        public static RangeWindowBuilder range() {
            return new RangeWindowBuilder();
        }

        public static DocumentWindowBuilder documents() {
            return new DocumentWindowBuilder();
        }
    }
}

