/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ConditionalOperators;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class RedactOperation
implements AggregationOperation {
    public static final String DESCEND = "$$DESCEND";
    public static final String KEEP = "$$KEEP";
    public static final String PRUNE = "$$PRUNE";
    private final AggregationExpression condition;

    public RedactOperation(AggregationExpression condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        this.condition = condition;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document(this.getOperator(), (Object)this.condition.toDocument(context));
    }

    @Override
    public String getOperator() {
        return "$redact";
    }

    public static RedactOperationBuilder builder() {
        return new RedactOperationBuilder();
    }

    public static class RedactOperationBuilder {
        private @Nullable Object when;
        private @Nullable Object then;
        private @Nullable Object otherwise;

        private RedactOperationBuilder() {
        }

        @Contract(value="_ -> this")
        public RedactOperationBuilder when(CriteriaDefinition criteria) {
            this.when = criteria;
            return this;
        }

        @Contract(value="_ -> this")
        public RedactOperationBuilder when(AggregationExpression condition) {
            this.when = condition;
            return this;
        }

        @Contract(value="_ -> this")
        public RedactOperationBuilder when(Document condition) {
            this.when = condition;
            return this;
        }

        @Contract(value="-> this")
        public RedactOperationBuilder thenDescend() {
            return this.then(RedactOperation.DESCEND);
        }

        @Contract(value="-> this")
        public RedactOperationBuilder thenKeep() {
            return this.then(RedactOperation.KEEP);
        }

        @Contract(value="-> this")
        public RedactOperationBuilder thenPrune() {
            return this.then(RedactOperation.PRUNE);
        }

        @Contract(value="_ -> this")
        public RedactOperationBuilder then(Object then) {
            this.then = then;
            return this;
        }

        @Contract(value="-> this")
        public RedactOperationBuilder otherwiseDescend() {
            return this.otherwise(RedactOperation.DESCEND);
        }

        @Contract(value="-> this")
        public RedactOperationBuilder otherwiseKeep() {
            return this.otherwise(RedactOperation.KEEP);
        }

        @Contract(value="-> this")
        public RedactOperationBuilder otherwisePrune() {
            return this.otherwise(RedactOperation.PRUNE);
        }

        @Contract(value="_ -> this")
        public RedactOperationBuilder otherwise(Object otherwise) {
            this.otherwise = otherwise;
            return this;
        }

        @Contract(value="-> new")
        public RedactOperation build() {
            Assert.notNull((Object)this.then, (String)"Then must be set first");
            Assert.notNull((Object)this.otherwise, (String)"Otherwise must be set first");
            return new RedactOperation(this.when().then(this.then).otherwise(this.otherwise));
        }

        private ConditionalOperators.Cond.ThenBuilder when() {
            Object object = this.when;
            if (object instanceof CriteriaDefinition) {
                CriteriaDefinition criteriaDefinition = (CriteriaDefinition)object;
                return ConditionalOperators.Cond.when(criteriaDefinition);
            }
            object = this.when;
            if (object instanceof AggregationExpression) {
                AggregationExpression aggregationExpression = (AggregationExpression)object;
                return ConditionalOperators.Cond.when(aggregationExpression);
            }
            object = this.when;
            if (object instanceof Document) {
                Document document = (Document)object;
                return ConditionalOperators.Cond.when(document);
            }
            throw new IllegalArgumentException(String.format("Invalid Condition; Expected CriteriaDefinition, AggregationExpression or Document but was %s", this.when));
        }
    }
}

