/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.ChangeStreamPreAndPostImagesOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.TimeSeriesGranularity;
import com.mongodb.client.model.TimeSeriesOptions;
import com.mongodb.client.model.ValidationOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.bson.BsonNull;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.core.PropertyPath;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.MappedDocument;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoJsonSchemaMapper;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.mapping.TimeSeries;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.timeseries.Granularity;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.mongodb.util.DurationUtil;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.util.Optionals;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class EntityOperations {
    private static final String ID_FIELD = FieldName.ID.name();
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context;
    private final QueryMapper queryMapper;
    private final EntityProjectionIntrospector introspector;
    private final MongoJsonSchemaMapper schemaMapper;
    private @Nullable Environment environment;

    EntityOperations(MongoConverter converter) {
        this(converter, new QueryMapper(converter));
    }

    EntityOperations(MongoConverter converter, QueryMapper queryMapper) {
        this(converter, converter.getMappingContext(), converter.getCustomConversions(), converter.getProjectionFactory(), queryMapper);
    }

    EntityOperations(MongoConverter converter, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, CustomConversions conversions, ProjectionFactory projectionFactory, QueryMapper queryMapper) {
        this.context = context;
        this.queryMapper = queryMapper;
        this.introspector = EntityProjectionIntrospector.create((ProjectionFactory)projectionFactory, (EntityProjectionIntrospector.ProjectionPredicate)EntityProjectionIntrospector.ProjectionPredicate.typeHierarchy().and((target, underlyingType) -> !conversions.isSimpleType(target)), context);
        this.schemaMapper = new MongoJsonSchemaMapper(converter);
        if (converter instanceof EnvironmentCapable) {
            EnvironmentCapable environmentCapable = (EnvironmentCapable)converter;
            this.environment = environmentCapable.getEnvironment();
        }
    }

    <T> Entity<T> forEntity(T entity) {
        Assert.notNull(entity, (String)"Bean must not be null");
        if (entity instanceof TargetAware) {
            TargetAware targetAware = (TargetAware)entity;
            return new SimpleMappedEntity<Map>((Map)targetAware.getTarget(), this);
        }
        if (entity instanceof String) {
            return new UnmappedEntity<Document>(EntityOperations.parse(entity.toString()), this);
        }
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity, this);
        }
        return MappedEntity.of(entity, this.context, this);
    }

    <T> AdaptibleEntity<T> forEntity(T entity, ConversionService conversionService) {
        Assert.notNull(entity, (String)"Bean must not be null");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        if (entity instanceof String) {
            return new UnmappedEntity<Document>(EntityOperations.parse(entity.toString()), this);
        }
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity, this);
        }
        return AdaptibleMappedEntity.of(entity, this.context, conversionService, this);
    }

    static boolean isCollectionLike(@Nullable Object source) {
        if (source == null) {
            return false;
        }
        return ObjectUtils.isArray((Object)source) || source instanceof Collection || source instanceof Iterator;
    }

    public String determineCollectionName(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity collection can't be determined");
        }
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.context.getPersistentEntity(entityClass);
        if (persistentEntity == null) {
            throw new MappingException(String.format("Cannot determine collection name from type '%s'. Is it a store native type?", entityClass.getName()));
        }
        return persistentEntity.getCollection();
    }

    public Query getByIdInQuery(Collection<?> entities) {
        LinkedMultiValueMap byIds = new LinkedMultiValueMap();
        entities.stream().map(this::forEntity).forEach(arg_0 -> EntityOperations.lambda$getByIdInQuery$0((MultiValueMap)byIds, arg_0));
        Criteria[] criterias = (Criteria[])byIds.entrySet().stream().map(it -> Criteria.where((String)it.getKey()).in((Collection)it.getValue())).toArray(Criteria[]::new);
        return new Query(criterias.length == 1 ? criterias[0] : new Criteria().orOperator(criterias));
    }

    public String getIdPropertyName(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.context.getPersistentEntity(type);
        if (persistentEntity != null && persistentEntity.getIdProperty() != null) {
            return ((MongoPersistentProperty)persistentEntity.getRequiredIdProperty()).getName();
        }
        return ID_FIELD;
    }

    public String nearQueryDistanceFieldName(Class<?> domainType) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.context.getPersistentEntity(domainType);
        if (persistentEntity == null || persistentEntity.getPersistentProperty("dis") == null) {
            return "dis";
        }
        Object distanceFieldName = "calculated-distance";
        int counter = 0;
        while (persistentEntity.getPersistentProperty((String)distanceFieldName) != null) {
            distanceFieldName = (String)distanceFieldName + "-" + counter++;
        }
        return distanceFieldName;
    }

    private static Document parse(String source) {
        try {
            return Document.parse((String)source);
        }
        catch (JsonParseException o_O) {
            throw new MappingException("Could not parse given String to save into a JSON document", (Throwable)o_O);
        }
        catch (RuntimeException o_O) {
            if (ClassUtils.matchesTypeName(o_O.getClass(), (String)"JSONParseException")) {
                throw new MappingException("Could not parse given String to save into a JSON document", (Throwable)o_O);
            }
            throw o_O;
        }
    }

    public <T> TypedOperations<T> forType(@Nullable Class<T> entityClass) {
        MongoPersistentEntity entity;
        if (entityClass != null && (entity = (MongoPersistentEntity)this.context.getPersistentEntity(entityClass)) != null) {
            return new TypedEntityOperations(entity, this.environment);
        }
        return UntypedOperations.instance();
    }

    public <M, D> EntityProjection<M, D> introspectProjection(Class<M> resultType, Class<D> entityType) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.queryMapper.getMappingContext().getPersistentEntity(entityType);
        if (persistentEntity == null && !resultType.isInterface() || ClassUtils.isAssignable(Document.class, resultType)) {
            return EntityProjection.nonProjecting(resultType);
        }
        return this.introspector.introspect(resultType, entityType);
    }

    public CreateCollectionOptions convertToCreateCollectionOptions(@Nullable CollectionOptions collectionOptions, Class<?> entityType) {
        Optional collation = Optionals.firstNonEmpty((Supplier[])new Supplier[]{() -> Optional.ofNullable(collectionOptions).flatMap(CollectionOptions::getCollation), () -> this.forType(entityType).getCollation()});
        CreateCollectionOptions result = new CreateCollectionOptions();
        collation.map(Collation::toMongoCollation).ifPresent(arg_0 -> ((CreateCollectionOptions)result).collation(arg_0));
        if (collectionOptions == null) {
            return result;
        }
        collectionOptions.getCapped().ifPresent(arg_0 -> ((CreateCollectionOptions)result).capped(arg_0));
        collectionOptions.getSize().ifPresent(arg_0 -> ((CreateCollectionOptions)result).sizeInBytes(arg_0));
        collectionOptions.getMaxDocuments().ifPresent(arg_0 -> ((CreateCollectionOptions)result).maxDocuments(arg_0));
        collectionOptions.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((CreateCollectionOptions)result).collation(arg_0));
        collectionOptions.getValidationOptions().ifPresent(it -> {
            ValidationOptions validationOptions = new ValidationOptions();
            it.getValidationAction().ifPresent(arg_0 -> ((ValidationOptions)validationOptions).validationAction(arg_0));
            it.getValidationLevel().ifPresent(arg_0 -> ((ValidationOptions)validationOptions).validationLevel(arg_0));
            it.getValidator().ifPresent(val -> validationOptions.validator((Bson)this.getMappedValidator((Validator)val, entityType)));
            result.validationOptions(validationOptions);
        });
        collectionOptions.getTimeSeriesOptions().map(this.forType(entityType)::mapTimeSeriesOptions).ifPresent(it -> {
            TimeSeriesOptions options = new TimeSeriesOptions(it.getTimeField());
            if (StringUtils.hasText((String)it.getMetaField())) {
                options.metaField(it.getMetaField());
            }
            if (!Granularity.DEFAULT.equals(it.getGranularity())) {
                options.granularity(TimeSeriesGranularity.valueOf((String)it.getGranularity().name().toUpperCase()));
            }
            if (it.getSpan() != null) {
                long bucketMaxSpanInSeconds = it.getSpan().time().toSeconds();
                options.bucketMaxSpan(Long.valueOf(bucketMaxSpanInSeconds), TimeUnit.SECONDS);
                options.bucketRounding(Long.valueOf(bucketMaxSpanInSeconds), TimeUnit.SECONDS);
            }
            if (!it.getExpireAfter().isNegative()) {
                result.expireAfter(it.getExpireAfter().toSeconds(), TimeUnit.SECONDS);
            }
            result.timeSeriesOptions(options);
        });
        collectionOptions.getChangeStreamOptions().map(CollectionOptions.CollectionChangeStreamOptions::getPreAndPostImages).map(ChangeStreamPreAndPostImagesOptions::new).ifPresent(arg_0 -> ((CreateCollectionOptions)result).changeStreamPreAndPostImagesOptions(arg_0));
        collectionOptions.getEncryptedFieldsOptions().map(CollectionOptions.EncryptedFieldsOptions::toDocument).filter(Predicate.not(Document::isEmpty)).ifPresent(arg_0 -> ((CreateCollectionOptions)result).encryptedFields(arg_0));
        return result;
    }

    private Document getMappedValidator(Validator validator, Class<?> domainType) {
        Document validationRules = validator.toDocument();
        if (validationRules.containsKey((Object)"$jsonSchema")) {
            return this.schemaMapper.mapSchema(validationRules, domainType);
        }
        return this.queryMapper.getMappedObject((Bson)validationRules, (MongoPersistentEntity)this.context.getPersistentEntity(domainType));
    }

    private static /* synthetic */ void lambda$getByIdInQuery$0(MultiValueMap byIds, Entity it) {
        byIds.add((Object)it.getIdFieldName(), it.getId());
    }

    private static class SimpleMappedEntity<T extends Map<String, Object>>
    extends UnmappedEntity<T> {
        protected SimpleMappedEntity(T map, EntityOperations entityOperations) {
            super(map, entityOperations);
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            Document document;
            Object bean = this.getBean();
            bean = bean instanceof Document ? (document = (Document)bean) : new Document((Map)bean);
            document = new Document();
            writer.write(bean, document);
            return MappedDocument.of(document);
        }
    }

    private static class UnmappedEntity<T extends Map<String, Object>>
    implements AdaptibleEntity<T> {
        private final T map;
        private final EntityOperations entityOperations;

        protected UnmappedEntity(T map, EntityOperations entityOperations) {
            this.map = map;
            this.entityOperations = entityOperations;
        }

        @Override
        public String getIdFieldName() {
            return ID_FIELD;
        }

        @Override
        public @Nullable Object getId() {
            return this.getPropertyValue(ID_FIELD);
        }

        @Override
        public @Nullable Object getPropertyValue(String key) {
            return this.map.get(key);
        }

        @Override
        public Query getByIdQuery() {
            return Query.query(Criteria.where(ID_FIELD).is(this.map.get(ID_FIELD)));
        }

        @Override
        public T populateIdIfNecessary(@Nullable Object id) {
            this.map.put((String)ID_FIELD, (Object)id);
            return this.map;
        }

        @Override
        public Query getQueryForVersion() {
            throw new MappingException("Cannot query for version on plain Documents");
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            Document document;
            T t = this.map;
            return MappedDocument.of(t instanceof Document ? (document = (Document)t) : new Document(this.map));
        }

        @Override
        public T initializeVersionProperty() {
            return this.map;
        }

        @Override
        public @Nullable Number getVersion() {
            return null;
        }

        @Override
        public T incrementVersion() {
            return this.map;
        }

        @Override
        public T getBean() {
            return this.map;
        }

        @Override
        public boolean isNew() {
            return this.map.get(ID_FIELD) != null;
        }

        @Override
        public Map<String, Object> extractKeys(Document sortObject, Class<?> sourceType) {
            LinkedHashMap<String, Object> keyset = new LinkedHashMap<String, Object>();
            MongoPersistentEntity sourceEntity = (MongoPersistentEntity)this.entityOperations.context.getPersistentEntity(sourceType);
            if (sourceEntity != null && sourceEntity.hasIdProperty()) {
                keyset.put(((MongoPersistentProperty)sourceEntity.getRequiredIdProperty()).getName(), this.getId());
            } else {
                keyset.put(ID_FIELD, this.getId());
            }
            for (String key : sortObject.keySet()) {
                Object value = this.resolveValue(key, sourceEntity);
                if (value == null) {
                    throw new IllegalStateException(String.format("Cannot extract value for key %s because its value is null", key));
                }
                keyset.put(key, value);
            }
            return keyset;
        }

        private @Nullable Object resolveValue(String key, @Nullable MongoPersistentEntity<?> sourceEntity) {
            if (sourceEntity == null) {
                return BsonUtils.resolveValue(this.map, key);
            }
            PropertyPath from = PropertyPath.from((String)key, (TypeInformation)sourceEntity.getTypeInformation());
            PersistentPropertyPath persistentPropertyPath = this.entityOperations.context.getPersistentPropertyPath(from);
            return BsonUtils.resolveValue(this.map, persistentPropertyPath.toDotPath(MongoPersistentProperty::getFieldName));
        }
    }

    private static class MappedEntity<T>
    implements Entity<T> {
        private final MongoPersistentEntity<?> entity;
        private final IdentifierAccessor idAccessor;
        private final PersistentPropertyAccessor<T> propertyAccessor;
        private final EntityOperations entityOperations;

        protected MappedEntity(MongoPersistentEntity<?> entity, IdentifierAccessor idAccessor, PersistentPropertyAccessor<T> propertyAccessor, EntityOperations entityOperations) {
            this.entity = entity;
            this.idAccessor = idAccessor;
            this.propertyAccessor = propertyAccessor;
            this.entityOperations = entityOperations;
        }

        private static <T> MappedEntity<T> of(T bean, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, EntityOperations entityOperations) {
            MongoPersistentEntity entity = (MongoPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new MappedEntity<T>(entity, identifierAccessor, propertyAccessor, entityOperations);
        }

        @Override
        public String getIdFieldName() {
            return ((MongoPersistentProperty)this.entity.getRequiredIdProperty()).getFieldName();
        }

        @Override
        public Object getId() {
            return this.idAccessor.getRequiredIdentifier();
        }

        @Override
        public @Nullable Object getPropertyValue(String key) {
            return this.propertyAccessor.getProperty(this.entity.getRequiredPersistentProperty(key));
        }

        @Override
        public Query getByIdQuery() {
            if (!this.entity.hasIdProperty()) {
                throw new MappingException("No id property found for object of type " + String.valueOf(this.entity.getType()));
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            return Query.query(Criteria.where(idProperty.getName()).is(this.getId()));
        }

        @Override
        public Query getQueryForVersion() {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            return new Query(Criteria.where(idProperty.getName()).is(this.getId()).and(versionProperty.getName()).is(this.getVersion()));
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            Object bean = this.propertyAccessor.getBean();
            Document document = new Document();
            writer.write(bean, document);
            if (document.containsKey((Object)ID_FIELD) && document.get((Object)ID_FIELD) == null) {
                document.remove((Object)ID_FIELD);
            }
            return MappedDocument.of(document);
        }

        @Override
        public void assertUpdateableIdIfNotSet() {
            if (!this.entity.hasIdProperty()) {
                return;
            }
            MongoPersistentProperty property = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            Object propertyValue = this.idAccessor.getIdentifier();
            if (propertyValue != null) {
                return;
            }
            if (!MongoSimpleTypes.AUTOGENERATED_ID_TYPES.contains(property.getType())) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot autogenerate id of type %s for entity of type %s", property.getType().getName(), this.entity.getType().getName()));
            }
        }

        @Override
        public boolean isVersionedEntity() {
            return this.entity.hasVersionProperty();
        }

        @Override
        public @Nullable Object getVersion() {
            return this.propertyAccessor.getProperty(this.entity.getRequiredVersionProperty());
        }

        @Override
        public T getBean() {
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public boolean isNew() {
            return this.entity.isNew(this.propertyAccessor.getBean());
        }

        @Override
        public Map<String, Object> extractKeys(Document sortObject, Class<?> sourceType) {
            LinkedHashMap<String, Object> keyset = new LinkedHashMap<String, Object>();
            MongoPersistentEntity sourceEntity = (MongoPersistentEntity)this.entityOperations.context.getPersistentEntity(sourceType);
            if (sourceEntity != null && sourceEntity.hasIdProperty()) {
                keyset.put(((MongoPersistentProperty)sourceEntity.getRequiredIdProperty()).getName(), this.getId());
            } else {
                keyset.put(((MongoPersistentProperty)this.entity.getRequiredIdProperty()).getName(), this.getId());
            }
            for (String key : sortObject.keySet()) {
                Object value = key.indexOf(46) != -1 ? this.getNestedPropertyValue(key) : this.getPropertyValue(key);
                if (value == null) {
                    throw new IllegalStateException(String.format("Cannot extract value for key %s because its value is null", key));
                }
                keyset.put(key, value);
            }
            return keyset;
        }

        private Object getNestedPropertyValue(String key) {
            String[] segments = key.split("\\.");
            Entity<Object> currentEntity = this;
            Object currentValue = BsonNull.VALUE;
            for (int i = 0; i < segments.length; ++i) {
                String segment = segments[i];
                currentValue = currentEntity.getPropertyValue(segment);
                if (i >= segments.length - 1) continue;
                if (currentValue == null) {
                    return BsonNull.VALUE;
                }
                currentEntity = this.entityOperations.forEntity(currentValue);
            }
            return currentValue != null ? currentValue : BsonNull.VALUE;
        }
    }

    private static class AdaptibleMappedEntity<T>
    extends MappedEntity<T>
    implements AdaptibleEntity<T> {
        private final MongoPersistentEntity<?> entity;
        private final ConvertingPropertyAccessor<T> propertyAccessor;
        private final IdentifierAccessor identifierAccessor;

        private AdaptibleMappedEntity(MongoPersistentEntity<?> entity, IdentifierAccessor identifierAccessor, ConvertingPropertyAccessor<T> propertyAccessor, EntityOperations entityOperations) {
            super(entity, identifierAccessor, propertyAccessor, entityOperations);
            this.entity = entity;
            this.propertyAccessor = propertyAccessor;
            this.identifierAccessor = identifierAccessor;
        }

        private static <T> AdaptibleEntity<T> of(T bean, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, ConversionService conversionService, EntityOperations entityOperations) {
            MongoPersistentEntity entity = (MongoPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new AdaptibleMappedEntity<T>(entity, identifierAccessor, new ConvertingPropertyAccessor(propertyAccessor, conversionService), entityOperations);
        }

        @Override
        public T populateIdIfNecessary(@Nullable Object id) {
            if (id == null) {
                return (T)this.propertyAccessor.getBean();
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getIdProperty();
            if (idProperty == null) {
                return (T)this.propertyAccessor.getBean();
            }
            if (this.identifierAccessor.getIdentifier() != null) {
                return (T)this.propertyAccessor.getBean();
            }
            this.propertyAccessor.setProperty((PersistentProperty)idProperty, id);
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public @Nullable Number getVersion() {
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            return (Number)this.propertyAccessor.getProperty((PersistentProperty)versionProperty, Number.class);
        }

        @Override
        public T initializeVersionProperty() {
            MongoPersistentProperty versionProperty;
            if (!this.entity.hasVersionProperty()) {
                return (T)this.propertyAccessor.getBean();
            }
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)((versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty()).getType().isPrimitive() ? 1 : 0));
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public T incrementVersion() {
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            Number version = this.getVersion();
            Long nextVersion = version == null ? 0L : version.longValue() + 1L;
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)nextVersion);
            return (T)this.propertyAccessor.getBean();
        }
    }

    static interface AdaptibleEntity<T>
    extends Entity<T> {
        public T populateIdIfNecessary(@Nullable Object var1);

        public T initializeVersionProperty();

        public T incrementVersion();

        @Override
        public @Nullable Number getVersion();
    }

    static class TypedEntityOperations<T>
    implements TypedOperations<T> {
        private final MongoPersistentEntity<T> entity;
        private final @Nullable Environment environment;

        protected TypedEntityOperations(MongoPersistentEntity<T> entity, @Nullable Environment environment) {
            this.entity = entity;
            this.environment = environment;
        }

        @Override
        public Optional<Collation> getCollation() {
            return Optional.ofNullable(this.entity.getCollation());
        }

        @Override
        public Optional<Collation> getCollation(Query query) {
            if (query.getCollation().isPresent()) {
                return query.getCollation();
            }
            return Optional.ofNullable(this.entity.getCollation());
        }

        @Override
        public CollectionOptions getCollectionOptions() {
            CollectionOptions collectionOptions = CollectionOptions.empty();
            if (this.entity.hasCollation()) {
                collectionOptions = collectionOptions.collation(this.entity.getCollation());
            }
            if (this.entity.isAnnotationPresent(TimeSeries.class)) {
                Duration timeout;
                TimeSeries timeSeries = (TimeSeries)this.entity.getRequiredAnnotation(TimeSeries.class);
                if (this.entity.getPersistentProperty(timeSeries.timeField()) == null) {
                    throw new MappingException(String.format("Time series field '%s' does not exist in type %s", timeSeries.timeField(), this.entity.getName()));
                }
                CollectionOptions.TimeSeriesOptions options = CollectionOptions.TimeSeriesOptions.timeSeries(timeSeries.timeField());
                if (StringUtils.hasText((String)timeSeries.metaField())) {
                    if (this.entity.getPersistentProperty(timeSeries.metaField()) == null) {
                        throw new MappingException(String.format("Meta field '%s' does not exist in type %s", timeSeries.metaField(), this.entity.getName()));
                    }
                    options = options.metaField(timeSeries.metaField());
                }
                if (!Granularity.DEFAULT.equals(timeSeries.granularity())) {
                    options = options.granularity(timeSeries.granularity());
                }
                if (StringUtils.hasText((String)timeSeries.expireAfter()) && !(timeout = TypedEntityOperations.computeIndexTimeout(timeSeries.expireAfter(), this.getEvaluationContextForEntity((PersistentEntity<?, ?>)this.entity))).isNegative()) {
                    options = options.expireAfter(timeout);
                }
                collectionOptions = collectionOptions.timeSeries(options);
            }
            return collectionOptions;
        }

        @Override
        public CollectionOptions.TimeSeriesOptions mapTimeSeriesOptions(CollectionOptions.TimeSeriesOptions source) {
            CollectionOptions.TimeSeriesOptions target = CollectionOptions.TimeSeriesOptions.timeSeries(this.mappedNameOrDefault(source.getTimeField()));
            if (StringUtils.hasText((String)source.getMetaField())) {
                target = target.metaField(this.mappedNameOrDefault(source.getMetaField()));
            }
            return target.granularity(source.getGranularity()).expireAfter(source.getExpireAfter()).span(source.getSpan());
        }

        @Override
        public String getIdKeyName() {
            return this.entity.getIdProperty() != null ? ((MongoPersistentProperty)this.entity.getIdProperty()).getName() : ID_FIELD;
        }

        private String mappedNameOrDefault(String name) {
            MongoPersistentProperty persistentProperty = (MongoPersistentProperty)this.entity.getPersistentProperty(name);
            return persistentProperty != null ? persistentProperty.getFieldName() : name;
        }

        private ValueEvaluationContext getEvaluationContextForEntity(@Nullable PersistentEntity<?, ?> persistentEntity) {
            if (persistentEntity instanceof BasicMongoPersistentEntity) {
                BasicMongoPersistentEntity mongoEntity = (BasicMongoPersistentEntity)persistentEntity;
                return mongoEntity.getValueEvaluationContext(null);
            }
            return ValueEvaluationContext.of((Environment)(this.environment != null ? this.environment : new StandardEnvironment()), (EvaluationContext)SimpleEvaluationContext.forReadOnlyDataBinding().build());
        }

        private static Duration computeIndexTimeout(String timeoutValue, ValueEvaluationContext evaluationContext) {
            return DurationUtil.evaluate(timeoutValue, evaluationContext);
        }
    }

    static enum UntypedOperations implements TypedOperations<Object>
    {
        INSTANCE;


        public static <T> TypedOperations<T> instance() {
            return INSTANCE;
        }

        @Override
        public Optional<Collation> getCollation() {
            return Optional.empty();
        }

        @Override
        public Optional<Collation> getCollation(Query query) {
            if (query == null) {
                return Optional.empty();
            }
            return query.getCollation();
        }

        @Override
        public CollectionOptions getCollectionOptions() {
            return CollectionOptions.empty();
        }

        @Override
        public CollectionOptions.TimeSeriesOptions mapTimeSeriesOptions(CollectionOptions.TimeSeriesOptions options) {
            return options;
        }
    }

    static interface TypedOperations<T> {
        public Optional<Collation> getCollation();

        public Optional<Collation> getCollation(Query var1);

        public CollectionOptions getCollectionOptions();

        public CollectionOptions.TimeSeriesOptions mapTimeSeriesOptions(CollectionOptions.TimeSeriesOptions var1);

        default public String getIdKeyName() {
            return ID_FIELD;
        }
    }

    static interface Entity<T> {
        public String getIdFieldName();

        public @Nullable Object getId();

        public @Nullable Object getPropertyValue(String var1);

        public Query getByIdQuery();

        default public Query getRemoveByQuery() {
            return this.isVersionedEntity() ? this.getQueryForVersion() : this.getByIdQuery();
        }

        public Query getQueryForVersion();

        public MappedDocument toMappedDocument(MongoWriter<? super T> var1);

        default public void assertUpdateableIdIfNotSet() {
        }

        default public boolean isVersionedEntity() {
            return false;
        }

        public @Nullable Object getVersion();

        public T getBean();

        public boolean isNew();

        public Map<String, Object> extractKeys(Document var1, Class<?> var2);
    }
}

