/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.config;

import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.repository.ReactiveMongoRepository;
import org.springframework.data.mongodb.repository.config.MongoRepositoryConfigurationExtension;
import org.springframework.data.mongodb.repository.support.ReactiveMongoRepositoryFactoryBean;
import org.springframework.data.mongodb.repository.support.SimpleReactiveMongoRepository;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.w3c.dom.Element;

public class ReactiveMongoRepositoryConfigurationExtension
extends MongoRepositoryConfigurationExtension {
    private static final String MONGO_TEMPLATE_REF = "reactive-mongo-template-ref";
    private static final String CREATE_QUERY_INDEXES = "create-query-indexes";

    @Override
    public String getModuleName() {
        return "Reactive MongoDB";
    }

    @Override
    public String getRepositoryBaseClassName() {
        return SimpleReactiveMongoRepository.class.getName();
    }

    @Override
    public String getRepositoryFactoryBeanClassName() {
        return ReactiveMongoRepositoryFactoryBean.class.getName();
    }

    @Override
    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(ReactiveMongoRepository.class);
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)MONGO_TEMPLATE_REF, (String)"reactiveMongoOperations");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)builder, (Element)element, (String)CREATE_QUERY_INDEXES, (String)"createIndexesForQueryMethods");
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("reactiveMongoOperations", attributes.getString("reactiveMongoTemplateRef"));
        builder.addPropertyValue("createIndexesForQueryMethods", (Object)attributes.getBoolean("createIndexesForQueryMethods"));
    }

    @Override
    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return metadata.isReactiveRepository();
    }
}

