/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.DiskUse;
import org.springframework.data.mongodb.repository.Hint;
import org.springframework.data.mongodb.repository.Meta;
import org.springframework.data.mongodb.repository.aot.MongoCodeBlocks;
import org.springframework.data.mongodb.repository.aot.QueryInteraction;
import org.springframework.data.mongodb.repository.aot.Snippet;
import org.springframework.data.mongodb.repository.aot.VariableSnippet;
import org.springframework.data.mongodb.repository.query.MongoQueryExecution;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.util.Lazy;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

class QueryBlocks {
    QueryBlocks() {
    }

    @NullUnmarked
    static class QueryCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private final Lazy<CodeBlock> queryParameters;
        private QueryInteraction source;
        private String queryVariableName;

        QueryCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
            this.queryParameters = Lazy.of(this::queryParametersCodeBlock);
        }

        CodeBlock queryParametersCodeBlock() {
            List allParameterNames = this.context.getAllParameterNames();
            if (allParameterNames.isEmpty()) {
                return CodeBlock.builder().build();
            }
            CodeBlock.Builder formatted = CodeBlock.builder();
            boolean containsArrayParameter = false;
            for (int i = 0; i < allParameterNames.size(); ++i) {
                String parameterName = (String)allParameterNames.get(i);
                Class parameterType = this.context.getMethodParameter(parameterName).getParameterType();
                if (this.source.getQuery().isRegexPlaceholderAt(i) && parameterType == String.class) {
                    String regexOptions = this.source.getQuery().getRegexOptions(i);
                    if (StringUtils.hasText((String)regexOptions)) {
                        formatted.add(CodeBlock.of((String)"toRegex($L)", (Object[])new Object[]{parameterName}));
                    } else {
                        formatted.add(CodeBlock.of((String)"toRegex($L, $S)", (Object[])new Object[]{parameterName, regexOptions}));
                    }
                } else {
                    formatted.add(CodeBlock.of((String)"$L", (Object[])new Object[]{parameterName}));
                }
                if (i + 1 < allParameterNames.size()) {
                    formatted.add(", ", new Object[0]);
                }
                if (containsArrayParameter || parameterType == null || !parameterType.isArray()) continue;
                containsArrayParameter = true;
            }
            if (containsArrayParameter && allParameterNames.size() == 1) {
                return CodeBlock.of((String)"new $T[] { $L }", (Object[])new Object[]{Object.class, formatted.build()});
            }
            return formatted.build();
        }

        public CodeBlock getQueryParameters() {
            return (CodeBlock)this.queryParameters.get();
        }

        QueryCodeBlockBuilder filter(QueryInteraction query) {
            this.source = query;
            return this;
        }

        QueryCodeBlockBuilder usingQueryVariableName(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        CodeBlock build() {
            String collationString;
            MergedAnnotation collationAnnotation;
            MergedAnnotation hintAnnotation;
            String hint;
            String limitParameter;
            String sortParameter;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add(this.buildJustTheQuery());
            if (StringUtils.hasText((String)this.source.getQuery().getFieldsString())) {
                VariableSnippet fields = Snippet.declare(builder).variable(Document.class, this.context.localVariable("fields")).of(MongoCodeBlocks.asDocument(this.context.getExpressionMarker(), this.source.getQuery().getFieldsString(), (CodeBlock)this.queryParameters.get()));
                builder.addStatement("$L.setFieldsObject($L)", new Object[]{this.queryVariableName, fields.getVariableName()});
            }
            if (StringUtils.hasText((String)this.source.getQuery().getSortString())) {
                VariableSnippet sort = Snippet.declare(builder).variable(Document.class, this.context.localVariable("sort")).of(MongoCodeBlocks.asDocument(this.context.getExpressionMarker(), this.source.getQuery().getSortString(), this.getQueryParameters()));
                builder.addStatement("$L.setSortObject($L)", new Object[]{this.queryVariableName, sort.getVariableName()});
            }
            if (StringUtils.hasText((String)(sortParameter = this.context.getSortParameterName()))) {
                builder.addStatement("$L.with($L)", new Object[]{this.queryVariableName, sortParameter});
            }
            if (StringUtils.hasText((String)(limitParameter = this.context.getLimitParameterName()))) {
                builder.addStatement("$L.limit($L)", new Object[]{this.queryVariableName, limitParameter});
            } else if (this.source.getQuery().isLimited()) {
                builder.addStatement("$L.limit($L)", new Object[]{this.queryVariableName, this.source.getQuery().getLimit()});
            }
            String pageableParameter = this.context.getPageableParameterName();
            if (StringUtils.hasText((String)pageableParameter) && !this.queryMethod.isPageQuery() && !this.queryMethod.isSliceQuery()) {
                builder.addStatement("$L.with($L)", new Object[]{this.queryVariableName, pageableParameter});
            }
            String string = hint = (hintAnnotation = this.context.getAnnotation(Hint.class)).isPresent() ? hintAnnotation.getString("value") : null;
            if (StringUtils.hasText((String)hint)) {
                builder.addStatement("$L.withHint($S)", new Object[]{this.queryVariableName, hint});
            }
            MongoCodeBlocks.appendReadPreference(this.context, builder, this.queryVariableName);
            MergedAnnotation metaAnnotation = this.context.getAnnotation(Meta.class);
            if (metaAnnotation.isPresent()) {
                String allowDiskUse;
                String comment;
                int cursorBatchSize;
                long maxExecutionTimeMs = metaAnnotation.getLong("maxExecutionTimeMs");
                if (maxExecutionTimeMs != -1L) {
                    builder.addStatement("$L.maxTimeMsec($L)", new Object[]{this.queryVariableName, maxExecutionTimeMs});
                }
                if ((cursorBatchSize = metaAnnotation.getInt("cursorBatchSize")) != 0) {
                    builder.addStatement("$L.cursorBatchSize($L)", new Object[]{this.queryVariableName, cursorBatchSize});
                }
                if (StringUtils.hasText((String)(comment = metaAnnotation.getString("comment")))) {
                    builder.addStatement("$L.comment($S)", new Object[]{this.queryVariableName, comment});
                }
                if (StringUtils.hasText((String)(allowDiskUse = metaAnnotation.getString("allowDiskUse")))) {
                    DiskUse diskUse = DiskUse.of(allowDiskUse);
                    builder.addStatement("$L.diskUse($T.$L)", new Object[]{this.queryVariableName, DiskUse.class, diskUse.name()});
                }
            }
            if ((collationAnnotation = this.context.getAnnotation(org.springframework.data.mongodb.core.annotation.Collation.class)).isPresent() && StringUtils.hasText((String)(collationString = collationAnnotation.getString("value")))) {
                if (!MongoCodeBlocks.containsPlaceholder(collationString)) {
                    builder.addStatement("$L.collation($T.parse($S))", new Object[]{this.queryVariableName, Collation.class, collationString});
                } else if (this.getQueryParameters().isEmpty()) {
                    builder.addStatement("$L.collation(collationOf(evaluate($L, $S)))", new Object[]{this.queryVariableName, this.context.getExpressionMarker().enclosingMethod(), collationString});
                } else {
                    builder.addStatement("$L.collation(collationOf(evaluate($L, $S, $L)))", new Object[]{this.queryVariableName, this.context.getExpressionMarker().enclosingMethod(), collationString, this.getQueryParameters()});
                }
            }
            return builder.build();
        }

        CodeBlock buildJustTheQuery() {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            Snippet.declare(builder).variable(BasicQuery.class, this.queryVariableName).of(this.renderExpressionToQuery());
            return builder.build();
        }

        private CodeBlock renderExpressionToQuery() {
            String source = this.source.getQuery().getQueryString();
            if (!StringUtils.hasText((String)source)) {
                return CodeBlock.of((String)"new $T(new $T())", (Object[])new Object[]{BasicQuery.class, Document.class});
            }
            if (MongoCodeBlocks.containsPlaceholder(source)) {
                CodeBlock.Builder builder = CodeBlock.builder();
                if (this.getQueryParameters().isEmpty()) {
                    builder.add("createQuery($L, $S)", new Object[]{this.context.getExpressionMarker().enclosingMethod(), source});
                } else {
                    builder.add("createQuery($L, $S, $L)", new Object[]{this.context.getExpressionMarker().enclosingMethod(), source, this.getQueryParameters()});
                }
                return builder.build();
            }
            return CodeBlock.of((String)"new $T(parse($S))", (Object[])new Object[]{BasicQuery.class, source});
        }
    }

    @NullUnmarked
    static class QueryExecutionCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private QueryInteraction query;

        QueryExecutionCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        QueryExecutionCodeBlockBuilder forQuery(QueryInteraction query) {
            this.query = query;
            return this;
        }

        CodeBlock build() {
            String terminatingMethod;
            String mongoOpsRef = this.context.fieldNameOf(MongoOperations.class);
            CodeBlock.Builder builder = CodeBlock.builder();
            boolean isProjecting = this.context.getReturnedType().isProjecting();
            Class domainType = this.context.getRepositoryInformation().getDomainType();
            Class actualReturnType = this.queryMethod.getParameters().hasDynamicProjection() || isProjecting ? TypeName.get((Type)this.context.getActualReturnType().getType()) : domainType;
            builder.add("\n", new Object[0]);
            if (this.queryMethod.getParameters().hasDynamicProjection()) {
                builder.addStatement("$T<$T> $L = $L.query($T.class).as($L)", new Object[]{ExecutableFindOperation.FindWithQuery.class, actualReturnType, this.context.localVariable("finder"), mongoOpsRef, domainType, this.context.getDynamicProjectionParameterName()});
            } else if (isProjecting) {
                builder.addStatement("$T<$T> $L = $L.query($T.class).as($T.class)", new Object[]{ExecutableFindOperation.FindWithQuery.class, actualReturnType, this.context.localVariable("finder"), mongoOpsRef, domainType, actualReturnType});
            } else {
                builder.addStatement("$T<$T> $L = $L.query($T.class)", new Object[]{ExecutableFindOperation.FindWithQuery.class, actualReturnType, this.context.localVariable("finder"), mongoOpsRef, domainType});
            }
            if (this.queryMethod.isCollectionQuery() || this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
                terminatingMethod = "all()";
            } else if (this.query.isCount()) {
                terminatingMethod = "count()";
            } else if (this.query.isExists()) {
                terminatingMethod = "exists()";
            } else if (this.queryMethod.isStreamQuery()) {
                terminatingMethod = "stream()";
            } else if (this.query.getQuery().isLimited()) {
                terminatingMethod = Optional.class.isAssignableFrom(this.context.getReturnType().toClass()) ? "first()" : "firstValue()";
            } else {
                String string = terminatingMethod = Optional.class.isAssignableFrom(this.context.getReturnType().toClass()) ? "one()" : "oneValue()";
            }
            if (this.queryMethod.isPageQuery()) {
                builder.addStatement("return new $T($L, $L).execute($L)", new Object[]{MongoQueryExecution.PagedExecution.class, this.context.localVariable("finder"), this.context.getPageableParameterName(), this.query.name()});
            } else if (this.queryMethod.isSliceQuery()) {
                builder.addStatement("return new $T($L, $L).execute($L)", new Object[]{MongoQueryExecution.SlicedExecution.class, this.context.localVariable("finder"), this.context.getPageableParameterName(), this.query.name()});
            } else if (this.queryMethod.isScrollQuery()) {
                String scrollPositionParameterName = this.context.getScrollPositionParameterName();
                if (scrollPositionParameterName != null) {
                    builder.addStatement("return $L.matching($L).scroll($L)", new Object[]{this.context.localVariable("finder"), this.query.name(), scrollPositionParameterName});
                } else {
                    String pageableParameterName = this.context.getPageableParameterName();
                    if (pageableParameterName != null) {
                        builder.addStatement("return $L.matching($L).scroll($L.toScrollPosition())", new Object[]{this.context.localVariable("finder"), this.query.name(), pageableParameterName});
                    } else {
                        builder.addStatement("return $L.matching($L).scroll($T.initial())", new Object[]{this.context.localVariable("finder"), this.query.name(), ScrollPosition.class});
                    }
                }
            } else if (this.query.isCount() && !ClassUtils.isAssignable(Long.class, (Class)this.context.getActualReturnType().getRawClass())) {
                Class returnType = ClassUtils.resolvePrimitiveIfNecessary((Class)this.queryMethod.getReturnedObjectType());
                builder.addStatement("return $T.convertNumberToTargetClass($L.matching($L).$L, $T.class)", new Object[]{NumberUtils.class, this.context.localVariable("finder"), this.query.name(), terminatingMethod, returnType});
            } else {
                builder.addStatement("return $L.matching($L).$L", new Object[]{this.context.localVariable("finder"), this.query.name(), terminatingMethod});
            }
            return builder.build();
        }
    }
}

