/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.mapping.KPropertyPathExtensionsKt;
import org.springframework.data.mongodb.core.query.Criteria;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a$\u0010\u0004\u001a\u00020\u0001\"\n\b\u0000\u0010\u0005*\u0004\u0018\u00010\u0003*\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\u001a'\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0016\u0010\u0002\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\b\"\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\t\u001a\u0012\u0010\n\u001a\u00020\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u0019\u0010\r\u001a\u00020\u0001*\u00020\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0086\u0004\u00a8\u0006\u000e"}, d2={"isEqualTo", "Lorg/springframework/data/mongodb/core/query/Criteria;", "o", "", "inValues", "T", "c", "", "", "(Lorg/springframework/data/mongodb/core/query/Criteria;[Ljava/lang/Object;)Lorg/springframework/data/mongodb/core/query/Criteria;", "where", "key", "Lkotlin/reflect/KProperty;", "and", "spring-data-mongodb"})
public final class CriteriaExtensionsKt {
    @NotNull
    public static final Criteria isEqualTo(@NotNull Criteria $this$isEqualTo, @Nullable Object o) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualTo, (String)"<this>");
        Criteria criteria = $this$isEqualTo.is(o);
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"is(...)");
        return criteria;
    }

    @NotNull
    public static final <T> Criteria inValues(@NotNull Criteria $this$inValues, @NotNull Collection<? extends T> c) {
        Intrinsics.checkNotNullParameter((Object)$this$inValues, (String)"<this>");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Criteria criteria = $this$inValues.in(c);
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"in(...)");
        return criteria;
    }

    @NotNull
    public static final Criteria inValues(@NotNull Criteria $this$inValues, Object ... o) {
        Intrinsics.checkNotNullParameter((Object)$this$inValues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Criteria criteria = $this$inValues.in(Arrays.copyOf(o, o.length));
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"in(...)");
        return criteria;
    }

    @NotNull
    public static final Criteria where(@NotNull KProperty<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Criteria criteria = Criteria.where(KPropertyPathExtensionsKt.toDotPath(key));
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"where(...)");
        return criteria;
    }

    @NotNull
    public static final Criteria and(@NotNull Criteria $this$and, @NotNull KProperty<?> key) {
        Intrinsics.checkNotNullParameter((Object)$this$and, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Criteria criteria = $this$and.and(KPropertyPathExtensionsKt.toDotPath(key));
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"and(...)");
        return criteria;
    }
}

