/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonRegularExpression;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Shape;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexType;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexed;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.MetricConversion;
import org.springframework.data.mongodb.core.query.MongoRegexCreator;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MongoQueryCreator
extends AbstractQueryCreator<Query, Criteria> {
    private static final Log LOG = LogFactory.getLog(MongoQueryCreator.class);
    private final MongoParameterAccessor accessor;
    private final MappingContext<?, MongoPersistentProperty> context;
    private final boolean isGeoNearQuery;
    private final boolean isSearchQuery;

    public MongoQueryCreator(PartTree tree, MongoParameterAccessor accessor, MappingContext<?, MongoPersistentProperty> context) {
        this(tree, accessor, context, false, false);
    }

    public MongoQueryCreator(PartTree tree, MongoParameterAccessor accessor, MappingContext<?, MongoPersistentProperty> context, boolean isGeoNearQuery, boolean isSearchQuery) {
        super(tree, (ParameterAccessor)accessor);
        Assert.notNull(context, (String)"MappingContext must not be null");
        this.accessor = accessor;
        this.isGeoNearQuery = isGeoNearQuery;
        this.isSearchQuery = isSearchQuery;
        this.context = context;
    }

    protected Criteria create(Part part, Iterator<Object> iterator) {
        if (this.isGeoNearQuery && part.getType().equals((Object)Part.Type.NEAR)) {
            return new Criteria();
        }
        if (this.isPartOfSearchQuery(part)) {
            MongoQueryCreator.skip(part, iterator);
            return new Criteria();
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        MongoPersistentProperty property = (MongoPersistentProperty)path.getLeafProperty();
        return this.from(part, property, Criteria.where(path.toDotPath()), iterator);
    }

    protected Criteria and(Part part, Criteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        if (this.isPartOfSearchQuery(part)) {
            MongoQueryCreator.skip(part, iterator);
            return base;
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        MongoPersistentProperty property = (MongoPersistentProperty)path.getLeafProperty();
        return this.from(part, property, base.and(path.toDotPath()), iterator);
    }

    protected Criteria or(Criteria base, Criteria criteria) {
        Criteria result = new Criteria();
        return result.orOperator(base, criteria);
    }

    protected Query complete(@Nullable Criteria criteria, Sort sort) {
        Query query = (criteria == null ? new Query() : new Query(criteria)).with(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created query " + String.valueOf(query)));
        }
        return query;
    }

    private Criteria from(Part part, MongoPersistentProperty property, Criteria criteria, Iterator<Object> parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return criteria.gt(parameters.next());
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(parameters.next());
            }
            case BEFORE: 
            case LESS_THAN: {
                return criteria.lt(parameters.next());
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(parameters.next());
            }
            case BETWEEN: {
                return MongoQueryCreator.computeBetweenPart(criteria, parameters);
            }
            case IS_NOT_NULL: {
                return criteria.ne(null);
            }
            case IS_NULL: {
                return criteria.is(null);
            }
            case NOT_IN: {
                return this.nin(criteria, part, parameters.next());
            }
            case IN: {
                return this.in(criteria, part, parameters.next());
            }
            case LIKE: 
            case STARTING_WITH: 
            case ENDING_WITH: 
            case CONTAINING: {
                return this.createContainingCriteria(part, property, criteria, parameters);
            }
            case NOT_LIKE: {
                return this.createContainingCriteria(part, property, criteria.not(), parameters);
            }
            case NOT_CONTAINING: {
                return this.createContainingCriteria(part, property, criteria.not(), parameters);
            }
            case REGEX: {
                return this.regex(criteria, parameters.next());
            }
            case EXISTS: {
                return this.exists(criteria, parameters.next());
            }
            case TRUE: {
                return criteria.is(true);
            }
            case FALSE: {
                return criteria.is(false);
            }
            case NEAR: {
                return this.createNearCriteria(property, criteria, parameters);
            }
            case WITHIN: {
                Object parameter = parameters.next();
                return criteria.within((Shape)parameter);
            }
            case SIMPLE_PROPERTY: {
                return this.isSimpleComparisonPossible(part) ? criteria.is(parameters.next()) : this.createLikeRegexCriteriaOrThrow(part, property, criteria, parameters, false);
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return this.isSimpleComparisonPossible(part) ? criteria.ne(parameters.next()) : this.createLikeRegexCriteriaOrThrow(part, property, criteria, parameters, true);
            }
        }
        throw new IllegalArgumentException("Unsupported keyword");
    }

    protected Criteria in(Criteria criteria, Part part, Object param) {
        return criteria.in(this.valueAsList(param, part));
    }

    protected Criteria nin(Criteria criteria, Part part, Object param) {
        return criteria.nin(this.valueAsList(param, part));
    }

    protected Criteria regex(Criteria criteria, Object param) {
        Criteria criteria2;
        if (param instanceof Pattern) {
            Pattern pattern = (Pattern)param;
            criteria2 = criteria.regex(pattern);
        } else {
            criteria2 = criteria.regex(param.toString());
        }
        return criteria2;
    }

    protected Criteria exists(Criteria criteria, Object param) {
        return criteria.exists((Boolean)param);
    }

    private Criteria createNearCriteria(MongoPersistentProperty property, Criteria criteria, Iterator<Object> parameters) {
        Range<Distance> range = this.accessor.getDistanceRange();
        Optional distance = range.getUpperBound().getValue();
        Optional minDistance = range.getLowerBound().getValue();
        Point point = this.accessor.getGeoNearLocation();
        Point pointToUse = point == null ? this.nextAs(parameters, Point.class) : point;
        boolean isSpherical = this.isSpherical(property);
        return distance.map(it -> {
            if (isSpherical || !Metrics.NEUTRAL.equals((Object)it.getMetric())) {
                criteria.nearSphere(pointToUse);
            } else {
                criteria.near(pointToUse);
            }
            if (pointToUse instanceof GeoJson) {
                criteria.maxDistance(MetricConversion.getDistanceInMeters(it));
                minDistance.map(MetricConversion::getDistanceInMeters).ifPresent(criteria::minDistance);
            } else {
                criteria.maxDistance(it.getNormalizedValue());
                minDistance.map(Distance::getNormalizedValue).ifPresent(criteria::minDistance);
            }
            return criteria;
        }).orElseGet(() -> isSpherical ? criteria.nearSphere(pointToUse) : criteria.near(pointToUse));
    }

    private boolean isSimpleComparisonPossible(Part part) {
        return switch (part.shouldIgnoreCase()) {
            default -> throw new IncompatibleClassChangeError();
            case Part.IgnoreCaseType.NEVER -> true;
            case Part.IgnoreCaseType.WHEN_POSSIBLE -> {
                if (part.getProperty().getType() != String.class) {
                    yield true;
                }
                yield false;
            }
            case Part.IgnoreCaseType.ALWAYS -> false;
        };
    }

    private Criteria createLikeRegexCriteriaOrThrow(Part part, MongoPersistentProperty property, Criteria criteria, Iterator<Object> parameters, boolean shouldNegateExpression) {
        PropertyPath path = part.getProperty().getLeafProperty();
        switch (part.shouldIgnoreCase()) {
            case ALWAYS: {
                if (path.getType() != String.class) {
                    throw new IllegalArgumentException(String.format("Part %s must be of type String but was %s", path, path.getType()));
                }
            }
            case WHEN_POSSIBLE: {
                if (shouldNegateExpression) {
                    criteria = criteria.not();
                }
                return this.addAppropriateLikeRegexTo(criteria, part, parameters.next());
            }
        }
        throw new IllegalArgumentException(String.format("part.shouldCaseIgnore must be one of %s, but was %s", Arrays.asList(Part.IgnoreCaseType.ALWAYS, Part.IgnoreCaseType.WHEN_POSSIBLE), part.shouldIgnoreCase()));
    }

    private Criteria createContainingCriteria(Part part, MongoPersistentProperty property, Criteria criteria, Iterator<Object> parameters) {
        if (property.isCollectionLike()) {
            Object next = parameters.next();
            return this.in(criteria, part, next);
        }
        return this.addAppropriateLikeRegexTo(criteria, part, parameters.next());
    }

    private Criteria addAppropriateLikeRegexTo(Criteria criteria, Part part, @Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for creating $regex pattern for property '%s' must not be null", part.getProperty().getSegment()));
        }
        return criteria.regex(this.toLikeRegex(value.toString(), part), this.toRegexOptions(part));
    }

    private @Nullable String toRegexOptions(Part part) {
        String regexOptions = null;
        switch (part.shouldIgnoreCase()) {
            case WHEN_POSSIBLE: 
            case ALWAYS: {
                regexOptions = "i";
            }
        }
        return regexOptions;
    }

    private <T> T nextAs(Iterator<Object> iterator, Class<T> type) {
        Object parameter = iterator.next();
        if (ClassUtils.isAssignable(type, parameter.getClass())) {
            return (T)parameter;
        }
        throw new IllegalArgumentException(String.format("Expected parameter type of %s but got %s", type, parameter.getClass()));
    }

    private List<?> valueAsList(Object value, Part part) {
        Streamable streamable = this.asStreamable(value);
        if (!this.isSimpleComparisonPossible(part)) {
            MongoRegexCreator.MatchMode matchMode = MongoQueryCreator.toMatchMode(part.getType());
            String regexOptions = this.toRegexOptions(part);
            streamable = streamable.map(it -> {
                if (it instanceof String) {
                    String sv = (String)it;
                    return new BsonRegularExpression(MongoRegexCreator.INSTANCE.toRegularExpression(sv, matchMode), regexOptions);
                }
                return it;
            });
        }
        return streamable.toList();
    }

    private Streamable<?> asStreamable(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return Streamable.of((Iterable)collection);
        }
        if (ObjectUtils.isArray((Object)value)) {
            return Streamable.of((Object[])((Object[])value));
        }
        return Streamable.of((Object[])new Object[]{value});
    }

    private String toLikeRegex(String source, Part part) {
        return MongoRegexCreator.INSTANCE.toRegularExpression(source, MongoQueryCreator.toMatchMode(part.getType()));
    }

    private boolean isSpherical(MongoPersistentProperty property) {
        if (property.isAnnotationPresent(GeoSpatialIndexed.class)) {
            GeoSpatialIndexed index = (GeoSpatialIndexed)property.findAnnotation(GeoSpatialIndexed.class);
            return index.type().equals((Object)GeoSpatialIndexType.GEO_2DSPHERE);
        }
        return false;
    }

    private boolean isPartOfSearchQuery(Part part) {
        return this.isSearchQuery && (part.getType().equals((Object)Part.Type.NEAR) || part.getType().equals((Object)Part.Type.WITHIN));
    }

    private static void skip(Part part, Iterator<?> parameters) {
        int total = part.getNumberOfArguments();
        for (int i = 0; parameters.hasNext() && i < total; ++i) {
            parameters.next();
        }
    }

    private static Criteria computeBetweenPart(Criteria criteria, Iterator<Object> parameters) {
        Object value = parameters.next();
        if (!(value instanceof Range)) {
            return criteria.gt(value).lt(parameters.next());
        }
        Range range = (Range)value;
        Optional min = range.getLowerBound().getValue();
        Optional max = range.getUpperBound().getValue();
        min.ifPresent(it -> {
            if (range.getLowerBound().isInclusive()) {
                criteria.gte(it);
            } else {
                criteria.gt(it);
            }
        });
        max.ifPresent(it -> {
            if (range.getUpperBound().isInclusive()) {
                criteria.lte(it);
            } else {
                criteria.lt(it);
            }
        });
        return criteria;
    }

    private static MongoRegexCreator.MatchMode toMatchMode(Part.Type type) {
        return switch (type) {
            case Part.Type.CONTAINING, Part.Type.NOT_CONTAINING -> MongoRegexCreator.MatchMode.CONTAINING;
            case Part.Type.STARTING_WITH -> MongoRegexCreator.MatchMode.STARTING_WITH;
            case Part.Type.ENDING_WITH -> MongoRegexCreator.MatchMode.ENDING_WITH;
            case Part.Type.LIKE, Part.Type.NOT_LIKE -> MongoRegexCreator.MatchMode.LIKE;
            case Part.Type.REGEX -> MongoRegexCreator.MatchMode.REGEX;
            case Part.Type.IN, Part.Type.SIMPLE_PROPERTY, Part.Type.NEGATING_SIMPLE_PROPERTY -> MongoRegexCreator.MatchMode.EXACT;
            default -> MongoRegexCreator.MatchMode.DEFAULT;
        };
    }
}

