/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.Collection;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.core.ResolvableType;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicUpdate;
import org.springframework.data.mongodb.repository.aot.MongoCodeBlocks;
import org.springframework.data.mongodb.repository.aot.Snippet;
import org.springframework.data.mongodb.repository.aot.UpdateInteraction;
import org.springframework.data.mongodb.repository.aot.VariableSnippet;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

class UpdateBlocks {
    UpdateBlocks() {
    }

    @NullUnmarked
    static class UpdateCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final String parameterNames;
        private UpdateInteraction source;
        private String updateVariableName;

        public UpdateCodeBlockBuilder(AotQueryMethodGenerationContext context) {
            this.context = context;
            String parameterNames = StringUtils.collectionToDelimitedString((Collection)context.getAllParameterNames(), (String)", ");
            this.parameterNames = StringUtils.hasText((String)parameterNames) ? ", " + parameterNames : "";
        }

        public UpdateCodeBlockBuilder update(UpdateInteraction update) {
            this.source = update;
            return this;
        }

        public UpdateCodeBlockBuilder usingUpdateVariableName(String updateVariableName) {
            this.updateVariableName = updateVariableName;
            return this;
        }

        CodeBlock build() {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            String tmpVariableName = this.updateVariableName + "Document";
            builder.add(MongoCodeBlocks.renderExpressionToDocument(this.source.getUpdate().getUpdateString(), tmpVariableName, this.parameterNames));
            builder.addStatement("$1T $2L = new $1T($3L)", new Object[]{BasicUpdate.class, this.updateVariableName, tmpVariableName});
            return builder.build();
        }
    }

    @NullUnmarked
    static class UpdateExecutionCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private String queryVariableName;
        private String updateVariableName;

        UpdateExecutionCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        UpdateExecutionCodeBlockBuilder withFilter(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        UpdateExecutionCodeBlockBuilder referencingUpdate(String updateVariableName) {
            this.updateVariableName = updateVariableName;
            return this;
        }

        CodeBlock build() {
            String mongoOpsRef = this.context.fieldNameOf(MongoOperations.class);
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            String updateReference = this.updateVariableName;
            Class domainType = this.context.getRepositoryInformation().getDomainType();
            VariableSnippet updater = Snippet.declare(builder).variable(ResolvableType.forClassWithGenerics(ExecutableUpdateOperation.ExecutableUpdate.class, (Class[])new Class[]{domainType}), this.context.localVariable("updater")).as("$L.update($T.class)", mongoOpsRef, domainType);
            Class returnType = ClassUtils.resolvePrimitiveIfNecessary((Class)this.queryMethod.getReturnedObjectType());
            if (ReflectionUtils.isVoid((Class)returnType)) {
                builder.addStatement("$L.matching($L).apply($L).all()", new Object[]{updater.getVariableName(), this.queryVariableName, updateReference});
            } else if (ClassUtils.isAssignable(Long.class, (Class)returnType)) {
                builder.addStatement("return $L.matching($L).apply($L).all().getModifiedCount()", new Object[]{updater.getVariableName(), this.queryVariableName, updateReference});
            } else {
                VariableSnippet modifiedCount = Snippet.declare(builder).variable(Long.class, this.context.localVariable("modifiedCount")).as("$L.matching($L).apply($L).all().getModifiedCount()", updater.getVariableName(), this.queryVariableName, updateReference);
                builder.addStatement("return $T.convertNumberToTargetClass($L, $T.class)", new Object[]{NumberUtils.class, modifiedCount.getVariableName(), returnType});
            }
            return builder.build();
        }
    }
}

