/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.List;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.Sphere;

class AotPlaceholders {
    AotPlaceholders() {
    }

    static Placeholder indexed(int position) {
        return new PlaceholderImpl("?" + position);
    }

    public static Shape geoJson(int index, String type) {
        return new GeoJsonPlaceholder(index, type);
    }

    public static Point point(int index) {
        return new PointPlaceholder(index);
    }

    public static Shape circle(int index) {
        return new CirclePlaceholder(index);
    }

    public static Shape box(int index) {
        return new BoxPlaceholder(index);
    }

    public static Shape sphere(int index) {
        return new SpherePlaceholder(index);
    }

    public static Shape polygon(int index) {
        return new PolygonPlaceholder(index);
    }

    record PlaceholderImpl(String expression) implements Placeholder
    {
        @Override
        public String getValue() {
            return this.expression;
        }

        @Override
        public String toString() {
            return this.getValue();
        }
    }

    private record GeoJsonPlaceholder(int index, String type) implements Placeholder,
    GeoJson<List<Placeholder>>,
    Shape
    {
        @Override
        public String getValue() {
            return "?" + this.index;
        }

        @Override
        public String getType() {
            return this.type();
        }

        @Override
        public String toString() {
            return this.getValue();
        }

        @Override
        public List<Placeholder> getCoordinates() {
            return List.of();
        }
    }

    private static class PointPlaceholder
    extends Point
    implements Placeholder {
        private final int index;

        public PointPlaceholder(int index) {
            super(Double.NaN, Double.NaN);
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        public String toString() {
            return this.getValue();
        }
    }

    private static class CirclePlaceholder
    extends Circle
    implements Placeholder {
        private final int index;

        public CirclePlaceholder(int index) {
            super((Point)new PointPlaceholder(index), Distance.of((double)1.0, (Metric)Metrics.NEUTRAL));
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        public String toString() {
            return this.getValue();
        }
    }

    private static class BoxPlaceholder
    extends Box
    implements Placeholder {
        private final int index;

        public BoxPlaceholder(int index) {
            super((Point)new PointPlaceholder(index), (Point)new PointPlaceholder(index));
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        public String toString() {
            return this.getValue();
        }
    }

    private static class SpherePlaceholder
    extends Sphere
    implements Placeholder {
        private final int index;

        public SpherePlaceholder(int index) {
            super((Point)new PointPlaceholder(index), Distance.of((double)1.0, (Metric)Metrics.NEUTRAL));
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        @Override
        public String toString() {
            return this.getValue();
        }
    }

    private static class PolygonPlaceholder
    extends Polygon
    implements Placeholder {
        private final int index;

        public PolygonPlaceholder(int index) {
            super((Point)new PointPlaceholder(index), (Point)new PointPlaceholder(index), (Point)new PointPlaceholder(index), new Point[]{new PointPlaceholder(index)});
            this.index = index;
        }

        @Override
        public String getValue() {
            return "?" + this.index;
        }

        public String toString() {
            return this.getValue();
        }
    }

    public static interface Placeholder {
        public String getValue();
    }
}

