/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import org.bson.conversions.Bson;
import org.jspecify.annotations.Nullable;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.CheckReturnValue;

public class MongoConversionContext
implements ValueConversionContext<MongoPersistentProperty> {
    private final PropertyValueProvider<MongoPersistentProperty> accessor;
    private final MongoConverter mongoConverter;
    private final @Nullable MongoPersistentProperty persistentProperty;
    private final @Nullable SpELContext spELContext;
    private final @Nullable OperatorContext operatorContext;

    public MongoConversionContext(PropertyValueProvider<MongoPersistentProperty> accessor, @Nullable MongoPersistentProperty persistentProperty, MongoConverter mongoConverter) {
        this(accessor, persistentProperty, mongoConverter, null, null);
    }

    public MongoConversionContext(PropertyValueProvider<MongoPersistentProperty> accessor, @Nullable MongoPersistentProperty persistentProperty, MongoConverter mongoConverter, @Nullable SpELContext spELContext) {
        this(accessor, persistentProperty, mongoConverter, spELContext, null);
    }

    public MongoConversionContext(PropertyValueProvider<MongoPersistentProperty> accessor, @Nullable MongoPersistentProperty persistentProperty, MongoConverter mongoConverter, @Nullable OperatorContext operatorContext) {
        this(accessor, persistentProperty, mongoConverter, null, operatorContext);
    }

    public MongoConversionContext(PropertyValueProvider<MongoPersistentProperty> accessor, @Nullable MongoPersistentProperty persistentProperty, MongoConverter mongoConverter, @Nullable SpELContext spELContext, @Nullable OperatorContext operatorContext) {
        this.accessor = accessor;
        this.persistentProperty = persistentProperty;
        this.mongoConverter = mongoConverter;
        this.spELContext = spELContext;
        this.operatorContext = operatorContext;
    }

    public MongoPersistentProperty getProperty() {
        if (this.persistentProperty == null) {
            throw new IllegalStateException("No underlying MongoPersistentProperty available");
        }
        return this.persistentProperty;
    }

    @CheckReturnValue
    public MongoConversionContext forOperator(@Nullable OperatorContext operatorContext) {
        return new MongoConversionContext(this.accessor, this.persistentProperty, this.mongoConverter, this.spELContext, operatorContext);
    }

    public @Nullable Object getValue(String propertyPath) {
        return this.accessor.getPropertyValue((PersistentProperty)((MongoPersistentProperty)this.getProperty().getOwner().getRequiredPersistentProperty(propertyPath)));
    }

    public <T> @Nullable T write(@Nullable Object value, TypeInformation<T> target) {
        return (T)this.mongoConverter.convertToMongoType(value, target);
    }

    public <T> @Nullable T read(@Nullable Object value, TypeInformation<T> target) {
        Object object;
        if (value instanceof Bson) {
            Bson bson = (Bson)value;
            object = this.mongoConverter.read(target.getType(), bson);
        } else {
            object = super.read(value, target);
        }
        return (T)object;
    }

    public @Nullable SpELContext getSpELContext() {
        return this.spELContext;
    }

    public @Nullable OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public static interface OperatorContext {
        public String operator();

        public String path();

        public boolean isWriteOperation();
    }

    record QueryOperatorContext(String operator, String path) implements OperatorContext
    {
        public QueryOperatorContext(@Nullable String operator, String path) {
            this.operator = operator != null ? operator : "$eq";
            this.path = path;
        }

        @Override
        public boolean isWriteOperation() {
            return false;
        }
    }

    record WriteOperatorContext(String path) implements OperatorContext
    {
        @Override
        public String operator() {
            return "write";
        }

        @Override
        public boolean isWriteOperation() {
            return true;
        }
    }
}

