/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.UuidRepresentation;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.SpringDataMongoDB;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoClientFactoryBean
extends AbstractFactoryBean<MongoClient>
implements PersistenceExceptionTranslator {
    private @Nullable MongoClientSettings mongoClientSettings;
    private @Nullable String host;
    private @Nullable Integer port;
    private @Nullable List<MongoCredential> credential = null;
    private @Nullable ConnectionString connectionString;
    private @Nullable String replicaSet = null;
    private PersistenceExceptionTranslator exceptionTranslator = MongoExceptionTranslator.DEFAULT_EXCEPTION_TRANSLATOR;

    public void setMongoClientSettings(@Nullable MongoClientSettings mongoClientOptions) {
        this.mongoClientSettings = mongoClientOptions;
    }

    public void setCredential(MongoCredential @Nullable [] credential) {
        this.credential = Arrays.asList(credential);
    }

    public void setHost(@Nullable String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnectionString(@Nullable ConnectionString connectionString) {
        this.connectionString = connectionString;
    }

    public void setReplicaSet(@Nullable String replicaSet) {
        this.replicaSet = replicaSet;
    }

    public void setExceptionTranslator(@Nullable PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? MongoExceptionTranslator.DEFAULT_EXCEPTION_TRANSLATOR : exceptionTranslator;
    }

    public @Nullable DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    public Class<? extends MongoClient> getObjectType() {
        return MongoClient.class;
    }

    protected MongoClient createInstance() throws Exception {
        return this.createMongoClient(this.computeClientSetting());
    }

    protected void destroyInstance(@Nullable MongoClient instance) throws Exception {
        if (instance != null) {
            instance.close();
        }
    }

    protected MongoClientSettings computeClientSetting() {
        if (this.connectionString != null && (StringUtils.hasText((String)this.host) || this.port != null)) {
            throw new IllegalStateException("ConnectionString and host/port configuration exclude one another");
        }
        ConnectionString connectionString = this.connectionString != null ? this.connectionString : new ConnectionString(String.format("mongodb://%s:%s", this.getOrDefault(this.host, ServerAddress.defaultHost()), this.getOrDefault(this.port, "" + ServerAddress.defaultPort())));
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyConnectionString(connectionString);
        builder.uuidRepresentation(UuidRepresentation.JAVA_LEGACY);
        if (this.mongoClientSettings != null) {
            MongoClientSettings defaultSettings = MongoClientSettings.builder().build();
            SslSettings sslSettings = this.mongoClientSettings.getSslSettings();
            ClusterSettings clusterSettings = this.mongoClientSettings.getClusterSettings();
            ConnectionPoolSettings connectionPoolSettings = this.mongoClientSettings.getConnectionPoolSettings();
            SocketSettings socketSettings = this.mongoClientSettings.getSocketSettings();
            ServerSettings serverSettings = this.mongoClientSettings.getServerSettings();
            builder = builder.applicationName(this.computeSettingsValue(defaultSettings.getApplicationName(), this.mongoClientSettings.getApplicationName(), connectionString.getApplicationName())).applyToSslSettings(settings -> {
                this.applySettings(arg_0 -> ((SslSettings.Builder)settings).enabled(arg_0), this.computeSettingsValue(SslSettings::isEnabled, defaultSettings.getSslSettings(), sslSettings, connectionString.getSslEnabled()));
                this.applySettings(arg_0 -> ((SslSettings.Builder)settings).invalidHostNameAllowed(arg_0), this.computeSettingsValue(SslSettings::isInvalidHostNameAllowed, defaultSettings.getSslSettings(), sslSettings, connectionString.getSslInvalidHostnameAllowed()));
                settings.context(sslSettings.getContext());
            }).applyToClusterSettings(settings -> {
                this.applySettings(arg_0 -> ((ClusterSettings.Builder)settings).hosts(arg_0), this.computeSettingsValue(ClusterSettings::getHosts, defaultSettings.getClusterSettings(), clusterSettings, connectionString.getHosts().stream().map(ServerAddress::new).collect(Collectors.toList())));
                this.applySettings(arg_0 -> ((ClusterSettings.Builder)settings).requiredReplicaSetName(arg_0), this.computeSettingsValue(ClusterSettings::getRequiredReplicaSetName, defaultSettings.getClusterSettings(), clusterSettings, connectionString.getRequiredReplicaSetName()));
                this.applySettings(arg_0 -> ((ClusterSettings.Builder)settings).srvHost(arg_0), this.computeSettingsValue(ClusterSettings::getSrvHost, defaultSettings.getClusterSettings(), clusterSettings, null));
                this.applySettings(arg_0 -> ((ClusterSettings.Builder)settings).mode(arg_0), this.computeSettingsValue(ClusterSettings::getMode, defaultSettings.getClusterSettings(), clusterSettings, null));
                this.applySettings(it -> settings.localThreshold(it.longValue(), TimeUnit.MILLISECONDS), (Number)this.computeSettingsValue(it -> it.getLocalThreshold(TimeUnit.MILLISECONDS), defaultSettings.getClusterSettings(), clusterSettings, connectionString.getLocalThreshold()));
                this.applySettings(arg_0 -> ((ClusterSettings.Builder)settings).requiredClusterType(arg_0), this.computeSettingsValue(ClusterSettings::getRequiredClusterType, defaultSettings.getClusterSettings(), clusterSettings, null));
                this.applySettings(it -> settings.serverSelectionTimeout(it.longValue(), TimeUnit.MILLISECONDS), (Number)this.computeSettingsValue(it -> it.getServerSelectionTimeout(TimeUnit.MILLISECONDS), defaultSettings.getClusterSettings(), clusterSettings, connectionString.getServerSelectionTimeout()));
                this.applySettings(arg_0 -> ((ClusterSettings.Builder)settings).serverSelector(arg_0), this.computeSettingsValue(ClusterSettings::getServerSelector, defaultSettings.getClusterSettings(), clusterSettings, null));
                List clusterListeners = this.computeSettingsValue(ClusterSettings::getClusterListeners, defaultSettings.getClusterSettings(), clusterSettings, null);
                if (clusterListeners != null) {
                    clusterListeners.forEach(arg_0 -> ((ClusterSettings.Builder)settings).addClusterListener(arg_0));
                }
            }).applyToConnectionPoolSettings(settings -> {
                this.applySettings(it -> settings.maintenanceFrequency(it.longValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getMaintenanceFrequency(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, null));
                this.applySettings(it -> settings.maxConnectionIdleTime(it.longValue(), TimeUnit.MILLISECONDS), (Number)this.computeSettingsValue(it -> it.getMaxConnectionIdleTime(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMaxConnectionIdleTime()));
                this.applySettings(it -> settings.maxConnectionLifeTime(it.longValue(), TimeUnit.MILLISECONDS), (Number)this.computeSettingsValue(it -> it.getMaxConnectionLifeTime(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMaxConnectionLifeTime()));
                this.applySettings(it -> settings.maxWaitTime(it.longValue(), TimeUnit.MILLISECONDS), (Number)this.computeSettingsValue(it -> it.getMaxWaitTime(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMaxWaitTime()));
                this.applySettings(it -> settings.maintenanceInitialDelay(it.longValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getMaintenanceInitialDelay(TimeUnit.MILLISECONDS), defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, null));
                this.applySettings(arg_0 -> ((ConnectionPoolSettings.Builder)settings).minSize(arg_0), this.computeSettingsValue(ConnectionPoolSettings::getMinSize, defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMinConnectionPoolSize()));
                this.applySettings(arg_0 -> ((ConnectionPoolSettings.Builder)settings).maxSize(arg_0), this.computeSettingsValue(ConnectionPoolSettings::getMaxSize, defaultSettings.getConnectionPoolSettings(), connectionPoolSettings, connectionString.getMaxConnectionPoolSize()));
            }).applyToSocketSettings(settings -> {
                this.applySettings(it -> settings.connectTimeout((long)it.intValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getConnectTimeout(TimeUnit.MILLISECONDS), defaultSettings.getSocketSettings(), socketSettings, connectionString.getConnectTimeout()));
                this.applySettings(it -> settings.readTimeout((long)it.intValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getReadTimeout(TimeUnit.MILLISECONDS), defaultSettings.getSocketSettings(), socketSettings, connectionString.getSocketTimeout()));
                this.applySettings(arg_0 -> ((SocketSettings.Builder)settings).receiveBufferSize(arg_0), this.computeSettingsValue(SocketSettings::getReceiveBufferSize, defaultSettings.getSocketSettings(), socketSettings, null));
                this.applySettings(arg_0 -> ((SocketSettings.Builder)settings).sendBufferSize(arg_0), this.computeSettingsValue(SocketSettings::getSendBufferSize, defaultSettings.getSocketSettings(), socketSettings, null));
            }).applyToServerSettings(settings -> {
                this.applySettings(it -> settings.minHeartbeatFrequency((long)it.intValue(), TimeUnit.MILLISECONDS), this.computeSettingsValue(it -> it.getMinHeartbeatFrequency(TimeUnit.MILLISECONDS), defaultSettings.getServerSettings(), serverSettings, null));
                this.applySettings(it -> settings.heartbeatFrequency((long)it.intValue(), TimeUnit.MILLISECONDS), (Number)this.computeSettingsValue(it -> it.getHeartbeatFrequency(TimeUnit.MILLISECONDS), defaultSettings.getServerSettings(), serverSettings, connectionString.getHeartbeatFrequency()));
                settings.applySettings(serverSettings);
            }).autoEncryptionSettings(this.mongoClientSettings.getAutoEncryptionSettings()).codecRegistry(this.mongoClientSettings.getCodecRegistry());
            this.applySettings(arg_0 -> ((MongoClientSettings.Builder)builder).readConcern(arg_0), this.computeSettingsValue(defaultSettings.getReadConcern(), this.mongoClientSettings.getReadConcern(), connectionString.getReadConcern()));
            this.applySettings(arg_0 -> ((MongoClientSettings.Builder)builder).writeConcern(arg_0), this.computeSettingsValue(defaultSettings.getWriteConcern(), this.mongoClientSettings.getWriteConcern(), connectionString.getWriteConcern()));
            this.applySettings(arg_0 -> ((MongoClientSettings.Builder)builder).readPreference(arg_0), this.computeSettingsValue(defaultSettings.getReadPreference(), this.mongoClientSettings.getReadPreference(), connectionString.getReadPreference()));
            this.applySettings(arg_0 -> ((MongoClientSettings.Builder)builder).retryReads(arg_0), this.computeSettingsValue(defaultSettings.getRetryReads(), this.mongoClientSettings.getRetryReads(), connectionString.getRetryReads()));
            this.applySettings(arg_0 -> ((MongoClientSettings.Builder)builder).retryWrites(arg_0), this.computeSettingsValue(defaultSettings.getRetryWrites(), this.mongoClientSettings.getRetryWrites(), connectionString.getRetryWritesValue()));
            this.applySettings(arg_0 -> ((MongoClientSettings.Builder)builder).uuidRepresentation(arg_0), this.computeSettingsValue(null, this.mongoClientSettings.getUuidRepresentation(), UuidRepresentation.JAVA_LEGACY));
        }
        if (!CollectionUtils.isEmpty(this.credential)) {
            builder = builder.credential(this.credential.iterator().next());
        }
        if (StringUtils.hasText((String)this.replicaSet)) {
            builder.applyToClusterSettings(settings -> settings.requiredReplicaSetName(this.replicaSet));
        }
        return builder.build();
    }

    private <T> void applySettings(Consumer<T> settingsBuilder, @Nullable T value) {
        if (ObjectUtils.isEmpty(value)) {
            return;
        }
        settingsBuilder.accept(value);
    }

    private <S, T> @Nullable T computeSettingsValue(Function<S, T> function, S defaultValueHolder, S settingsValueHolder, @Nullable T connectionStringValue) {
        return this.computeSettingsValue(function.apply(defaultValueHolder), function.apply(settingsValueHolder), connectionStringValue);
    }

    private <T> @Nullable T computeSettingsValue(@Nullable T defaultValue, T fromSettings, @Nullable T fromConnectionString) {
        boolean fromSettingsIsDefault = ObjectUtils.nullSafeEquals(defaultValue, fromSettings);
        boolean fromConnectionStringIsDefault = ObjectUtils.nullSafeEquals(defaultValue, fromConnectionString);
        if (!fromSettingsIsDefault) {
            return fromSettings;
        }
        return !fromConnectionStringIsDefault ? fromConnectionString : defaultValue;
    }

    private MongoClient createMongoClient(MongoClientSettings settings) throws UnknownHostException {
        return MongoClients.create((MongoClientSettings)settings, (MongoDriverInformation)SpringDataMongoDB.driverInformation());
    }

    private String getOrDefault(@Nullable Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String sValue = value.toString();
        return StringUtils.hasText((String)sValue) ? sValue : defaultValue;
    }
}

