/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import com.mongodb.DBRef;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bson.conversions.Bson;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Vector;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.aot.StringQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.TypeInformation;

class AotQueryCreator {
    private MongoMappingContext mappingContext;

    public AotQueryCreator() {
        MongoMappingContext mongoMappingContext = new MongoMappingContext();
        mongoMappingContext.setSimpleTypeHolder(MongoCustomConversions.create(cfg -> cfg.useNativeDriverJavaTimeCodecs()).getSimpleTypeHolder());
        mongoMappingContext.setAutoIndexCreation(false);
        mongoMappingContext.afterPropertiesSet();
        this.mappingContext = mongoMappingContext;
    }

    StringQuery createQuery(PartTree partTree, int parameterCount) {
        Query query = (Query)new MongoQueryCreator(partTree, new PlaceholderConvertingParameterAccessor(new PlaceholderParameterAccessor(parameterCount)), (MappingContext<?, MongoPersistentProperty>)this.mappingContext).createQuery();
        if (partTree.isLimiting()) {
            query.limit(partTree.getMaxResults());
        }
        return new StringQuery(query);
    }

    static class PlaceholderConvertingParameterAccessor
    extends ConvertingParameterAccessor {
        public PlaceholderConvertingParameterAccessor(PlaceholderParameterAccessor delegate) {
            super(PlaceholderWriter.INSTANCE, delegate);
        }
    }

    @NullUnmarked
    static class PlaceholderParameterAccessor
    implements MongoParameterAccessor {
        private final List<CriteriaDefinition.Placeholder> placeholders;

        public PlaceholderParameterAccessor(int parameterCount) {
            this.placeholders = parameterCount == 0 ? List.of() : IntStream.range(0, parameterCount).mapToObj(CriteriaDefinition.Placeholder::indexed).collect(Collectors.toList());
        }

        @Override
        public Range<Distance> getDistanceRange() {
            return null;
        }

        public @Nullable Vector getVector() {
            return null;
        }

        public @Nullable Score getScore() {
            return null;
        }

        public @Nullable Range<Score> getScoreRange() {
            return null;
        }

        @Override
        public @Nullable Point getGeoNearLocation() {
            return null;
        }

        @Override
        public @Nullable TextCriteria getFullText() {
            return null;
        }

        @Override
        public @Nullable Collation getCollation() {
            return null;
        }

        @Override
        public Object[] getValues() {
            return this.placeholders.toArray();
        }

        @Override
        public @Nullable UpdateDefinition getUpdate() {
            return null;
        }

        public @Nullable ScrollPosition getScrollPosition() {
            return null;
        }

        public Pageable getPageable() {
            return null;
        }

        public Sort getSort() {
            return null;
        }

        public @Nullable Class<?> findDynamicProjection() {
            return null;
        }

        public @Nullable Object getBindableValue(int index) {
            return this.placeholders.get(index).getValue();
        }

        public boolean hasBindableNullValue() {
            return false;
        }

        public Iterator<Object> iterator() {
            return this.placeholders.iterator();
        }
    }

    @NullUnmarked
    static enum PlaceholderWriter implements MongoWriter<Object>
    {
        INSTANCE;


        @Override
        public @Nullable Object convertToMongoType(@Nullable Object obj, @Nullable TypeInformation<?> typeInformation) {
            Object object;
            if (obj instanceof CriteriaDefinition.Placeholder) {
                CriteriaDefinition.Placeholder p = (CriteriaDefinition.Placeholder)obj;
                object = p.getValue();
            } else {
                object = obj;
            }
            return object;
        }

        @Override
        public DBRef toDBRef(Object object, @Nullable MongoPersistentProperty referringProperty) {
            return null;
        }

        public void write(Object source, Bson sink) {
        }
    }
}

