/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

class BeanValidationDelegate {
    private static final Log LOG = LogFactory.getLog(BeanValidationDelegate.class);
    private final Validator validator;

    public BeanValidationDelegate(Validator validator) {
        Assert.notNull((Object)validator, (String)"Validator must not be null");
        this.validator = validator;
    }

    public Set<ConstraintViolation<Object>> validate(Object object) {
        Set violations;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Validating object: %s", object));
        }
        if (!(violations = this.validator.validate(object, new Class[0])).isEmpty() && LOG.isDebugEnabled()) {
            LOG.info((Object)String.format("During object: %s validation violations found: %s", object, violations));
        }
        return violations;
    }
}

