/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.util.Assert;

public class LiteralOperators {
    public static LiteralOperatorFactory valueOf(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        return new LiteralOperatorFactory(value);
    }

    public static class LiteralOperatorFactory {
        private final Object value;

        public LiteralOperatorFactory(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            this.value = value;
        }

        public Literal asLiteral() {
            return Literal.asLiteral(this.value);
        }
    }

    public static class Literal
    extends AbstractAggregationExpression {
        private Literal(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$literal";
        }

        public static Literal asLiteral(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new Literal(value);
        }
    }
}

