/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadPublisher;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.BsonValue;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.data.mongodb.gridfs.GridFsObject;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveGridFsResource
implements GridFsObject<Object, Publisher<DataBuffer>> {
    private final AtomicBoolean consumed = new AtomicBoolean(false);
    @Nullable
    private final Object id;
    private final GridFsObject.Options options;
    private final String filename;
    @Nullable
    private final GridFSDownloadPublisher downloadPublisher;
    private final DataBufferFactory dataBufferFactory;

    public ReactiveGridFsResource(String filename, @Nullable GridFSDownloadPublisher downloadPublisher) {
        this(null, filename, GridFsObject.Options.none(), downloadPublisher);
    }

    public ReactiveGridFsResource(@Nullable Object id, String filename, GridFsObject.Options options, @Nullable GridFSDownloadPublisher downloadPublisher) {
        this(id, filename, options, downloadPublisher, (DataBufferFactory)new DefaultDataBufferFactory());
    }

    ReactiveGridFsResource(GridFSFile file, @Nullable GridFSDownloadPublisher downloadPublisher, DataBufferFactory dataBufferFactory) {
        this(file.getId(), file.getFilename(), GridFsObject.Options.from(file), downloadPublisher, dataBufferFactory);
    }

    ReactiveGridFsResource(@Nullable Object id, String filename, GridFsObject.Options options, @Nullable GridFSDownloadPublisher downloadPublisher, DataBufferFactory dataBufferFactory) {
        this.id = id;
        this.filename = filename;
        this.options = options;
        this.downloadPublisher = downloadPublisher;
        this.dataBufferFactory = dataBufferFactory;
    }

    public static ReactiveGridFsResource absent(String filename) {
        Assert.notNull((Object)filename, (String)"Filename must not be null");
        return new ReactiveGridFsResource(filename, null);
    }

    @Override
    public Object getFileId() {
        Object object;
        Object object2 = this.id;
        if (object2 instanceof BsonValue) {
            BsonValue bsonValue = (BsonValue)object2;
            object = BsonUtils.toJavaType(bsonValue);
        } else {
            object = this.id;
        }
        return object;
    }

    @Override
    public String getFilename() throws IllegalStateException {
        return this.filename;
    }

    public Mono<GridFSFile> getGridFSFile() {
        return this.downloadPublisher != null ? Mono.from((Publisher)this.downloadPublisher.getGridFSFile()) : Mono.empty();
    }

    public Mono<InputStream> getInputStream() throws IllegalStateException {
        return ((Mono)this.getDownloadStream().transform(DataBufferUtils::join).as(Mono::from)).map(DataBuffer::asInputStream);
    }

    public Flux<DataBuffer> getDownloadStream() {
        if (this.downloadPublisher == null) {
            return Flux.empty();
        }
        return this.createDownloadStream(this.downloadPublisher);
    }

    @Override
    public Flux<DataBuffer> getContent() {
        return this.getDownloadStream();
    }

    @Override
    public GridFsObject.Options getOptions() {
        return this.options;
    }

    public Flux<DataBuffer> getDownloadStream(int chunkSize) {
        if (this.downloadPublisher == null) {
            return Flux.empty();
        }
        return this.createDownloadStream(this.downloadPublisher.bufferSizeBytes(chunkSize));
    }

    private Flux<DataBuffer> createDownloadStream(GridFSDownloadPublisher publisher) {
        return Flux.from((Publisher)publisher).map(arg_0 -> ((DataBufferFactory)this.dataBufferFactory).wrap(arg_0)).doOnSubscribe(it -> this.verifyStreamStillAvailable());
    }

    public boolean exists() {
        return this.downloadPublisher != null;
    }

    private void verifyStreamStillAvailable() {
        if (!this.consumed.compareAndSet(false, true)) {
            throw new IllegalStateException("Stream already consumed.");
        }
    }
}

