/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.util.Assert;

public class SampleOperation
implements AggregationOperation {
    private final long sampleSize;

    public SampleOperation(long sampleSize) {
        Assert.isTrue((sampleSize > 0L ? 1 : 0) != 0, (String)"Sample size must be greater than zero");
        this.sampleSize = sampleSize;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document(this.getOperator(), (Object)new Document("size", (Object)this.sampleSize));
    }

    @Override
    public String getOperator() {
        return "$sample";
    }
}

