/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.util.Optional;
import org.bson.Document;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexType;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexFilter;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GeospatialIndex
implements IndexDefinition {
    private final String field;
    @Nullable
    private String name;
    @Nullable
    private Integer min;
    @Nullable
    private Integer max;
    @Nullable
    private Integer bits;
    private GeoSpatialIndexType type = GeoSpatialIndexType.GEO_2D;
    private Double bucketSize = 1.0;
    @Nullable
    private String additionalField;
    private Optional<IndexFilter> filter = Optional.empty();
    private Optional<Collation> collation = Optional.empty();

    public GeospatialIndex(String field) {
        Assert.hasText((String)field, (String)"Field must have text");
        this.field = field;
    }

    public GeospatialIndex named(String name) {
        this.name = name;
        return this;
    }

    public GeospatialIndex withMin(int min) {
        this.min = min;
        return this;
    }

    public GeospatialIndex withMax(int max) {
        this.max = max;
        return this;
    }

    public GeospatialIndex withBits(int bits) {
        this.bits = bits;
        return this;
    }

    public GeospatialIndex typed(GeoSpatialIndexType type) {
        Assert.notNull((Object)((Object)type), (String)"Type must not be null");
        this.type = type;
        return this;
    }

    @Deprecated
    public GeospatialIndex withBucketSize(double bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public GeospatialIndex withAdditionalField(String fieldName) {
        this.additionalField = fieldName;
        return this;
    }

    public GeospatialIndex partial(@Nullable IndexFilter filter) {
        this.filter = Optional.ofNullable(filter);
        return this;
    }

    public GeospatialIndex collation(@Nullable Collation collation) {
        this.collation = Optional.ofNullable(collation);
        return this;
    }

    @Override
    public Document getIndexKeys() {
        Document document = new Document();
        switch (this.type) {
            case GEO_2D: {
                document.put(this.field, (Object)"2d");
                break;
            }
            case GEO_2DSPHERE: {
                document.put(this.field, (Object)"2dsphere");
                break;
            }
            case GEO_HAYSTACK: {
                document.put(this.field, (Object)"geoHaystack");
                if (!StringUtils.hasText((String)this.additionalField)) {
                    throw new IllegalArgumentException("When defining geoHaystack index, an additional field must be defined");
                }
                document.put(this.additionalField, (Object)1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported geospatial index " + this.type);
            }
        }
        return document;
    }

    @Override
    public Document getIndexOptions() {
        Document document = new Document();
        if (StringUtils.hasText((String)this.name)) {
            document.put("name", (Object)this.name);
        }
        switch (this.type) {
            case GEO_2D: {
                if (this.min != null) {
                    document.put("min", (Object)this.min);
                }
                if (this.max != null) {
                    document.put("max", (Object)this.max);
                }
                if (this.bits == null) break;
                document.put("bits", (Object)this.bits);
                break;
            }
            case GEO_2DSPHERE: {
                break;
            }
            case GEO_HAYSTACK: {
                document.put("bucketSize", (Object)this.bucketSize);
            }
        }
        this.filter.ifPresent(val -> document.put("partialFilterExpression", (Object)val.getFilterObject()));
        this.collation.ifPresent(val -> document.append("collation", (Object)val.toDocument()));
        return document;
    }

    public String toString() {
        return String.format("Geo index: %s - Options: %s", this.getIndexKeys(), this.getIndexOptions());
    }
}

