/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.FieldType;
import org.springframework.data.mongodb.core.mapping.Language;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.TextScore;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class BasicMongoPersistentProperty
extends AnnotationBasedPersistentProperty<MongoPersistentProperty>
implements MongoPersistentProperty {
    private static final Logger LOG = LoggerFactory.getLogger(BasicMongoPersistentProperty.class);
    private static final String ID_FIELD_NAME = "_id";
    private static final String LANGUAGE_FIELD_NAME = "language";
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet();
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>();
    private final FieldNamingStrategy fieldNamingStrategy;

    public BasicMongoPersistentProperty(Property property, MongoPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder, @Nullable FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        String annotatedName;
        Object object = this.fieldNamingStrategy = fieldNamingStrategy == null ? PropertyNameFieldNamingStrategy.INSTANCE : fieldNamingStrategy;
        if (this.isIdProperty() && this.hasExplicitFieldName() && !ID_FIELD_NAME.equals(annotatedName = this.getAnnotatedFieldName())) {
            LOG.warn("Customizing field name for id property '{}.{}' is not allowed! Custom name ('{}') will not be considered!", new Object[]{owner.getName(), this.getName(), annotatedName});
        }
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.getName()) && !this.hasExplicitFieldName();
    }

    @Override
    public boolean isExplicitIdProperty() {
        return this.isAnnotationPresent(Id.class);
    }

    @Override
    public String getFieldName() {
        if (this.isIdProperty()) {
            if (this.getOwner().getIdProperty() == null) {
                return ID_FIELD_NAME;
            }
            if (this.getOwner().isIdProperty((PersistentProperty)this)) {
                return ID_FIELD_NAME;
            }
        }
        if (this.hasExplicitFieldName()) {
            return this.getAnnotatedFieldName();
        }
        String fieldName = this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
        if (!StringUtils.hasText((String)fieldName)) {
            throw new MappingException(String.format("Invalid (null or empty) field name returned for property %s by %s!", this, this.fieldNamingStrategy.getClass()));
        }
        return fieldName;
    }

    @Override
    public Class<?> getFieldType() {
        Field fieldAnnotation = (Field)this.findAnnotation(Field.class);
        if (!this.isIdProperty()) {
            if (fieldAnnotation == null || fieldAnnotation.targetType() == FieldType.IMPLICIT) {
                return this.getType();
            }
            return fieldAnnotation.targetType().getJavaClass();
        }
        if (fieldAnnotation == null) {
            return FieldType.OBJECT_ID.getJavaClass();
        }
        FieldType fieldType = fieldAnnotation.targetType();
        if (fieldType == FieldType.IMPLICIT) {
            if (this.isEntity()) {
                return Document.class;
            }
            return this.getType();
        }
        return fieldType.getJavaClass();
    }

    protected boolean hasExplicitFieldName() {
        return StringUtils.hasText((String)this.getAnnotatedFieldName());
    }

    @Nullable
    private String getAnnotatedFieldName() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        return annotation != null ? annotation.value() : null;
    }

    @Override
    public int getFieldOrder() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        return annotation != null ? annotation.order() : Integer.MAX_VALUE;
    }

    protected Association<MongoPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public boolean isDbReference() {
        return this.isAnnotationPresent(DBRef.class);
    }

    @Override
    @Nullable
    public DBRef getDBRef() {
        return (DBRef)this.findAnnotation(DBRef.class);
    }

    @Override
    public boolean isLanguageProperty() {
        return this.getFieldName().equals(LANGUAGE_FIELD_NAME) || this.isExplicitLanguageProperty();
    }

    @Override
    public boolean isExplicitLanguageProperty() {
        return this.isAnnotationPresent(Language.class);
    }

    @Override
    public boolean isTextScoreProperty() {
        return this.isAnnotationPresent(TextScore.class);
    }

    static {
        SUPPORTED_ID_TYPES.add(ObjectId.class);
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_TYPES.add(BigInteger.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
        SUPPORTED_ID_PROPERTY_NAMES.add(ID_FIELD_NAME);
    }
}

