/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.reactivestreams.client.ClientSession;
import org.reactivestreams.Publisher;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class ReactiveMongoContext {
    private static final Class<?> SESSION_KEY = ClientSession.class;

    public static Mono<ClientSession> getSession() {
        return Mono.deferContextual(ctx -> {
            if (ctx.hasKey(SESSION_KEY)) {
                return (Mono)ctx.get(SESSION_KEY);
            }
            return Mono.empty();
        });
    }

    public static Context setSession(Context context, Publisher<ClientSession> session) {
        Assert.notNull((Object)context, (String)"Context must not be null!");
        Assert.notNull(session, (String)"Session publisher must not be null!");
        return context.put(SESSION_KEY, (Object)Mono.from(session));
    }
}

