/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ClientSessionOptions;
import com.mongodb.DB;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.session.ClientSession;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.SessionAwareMethodInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class MongoDbFactorySupport<C>
implements MongoDbFactory {
    private final C mongoClient;
    private final String databaseName;
    private final boolean mongoInstanceCreated;
    private final PersistenceExceptionTranslator exceptionTranslator;
    @Nullable
    private WriteConcern writeConcern;

    protected MongoDbFactorySupport(C mongoClient, String databaseName, boolean mongoInstanceCreated, PersistenceExceptionTranslator exceptionTranslator) {
        Assert.notNull(mongoClient, (String)"MongoClient must not be null!");
        Assert.hasText((String)databaseName, (String)"Database name must not be empty!");
        Assert.isTrue((boolean)databaseName.matches("[^/\\\\.$\"\\s]+"), (String)"Database name must not contain slashes, dots, spaces, quotes, or dollar signs!");
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
        this.mongoInstanceCreated = mongoInstanceCreated;
        this.exceptionTranslator = exceptionTranslator;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    @Override
    public MongoDatabase getDb() throws DataAccessException {
        return this.getDb(this.databaseName);
    }

    @Override
    public MongoDatabase getDb(String dbName) throws DataAccessException {
        Assert.hasText((String)dbName, (String)"Database name must not be empty!");
        MongoDatabase db = this.doGetMongoDatabase(dbName);
        if (this.writeConcern == null) {
            return db;
        }
        return db.withWriteConcern(this.writeConcern);
    }

    protected abstract MongoDatabase doGetMongoDatabase(String var1);

    public void destroy() throws Exception {
        if (this.mongoInstanceCreated) {
            this.closeClient();
        }
    }

    @Override
    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    @Override
    public MongoDbFactory withSession(com.mongodb.client.ClientSession session) {
        return new ClientSessionBoundMongoDbFactory(session, this);
    }

    protected abstract void closeClient();

    protected C getMongoClient() {
        return this.mongoClient;
    }

    protected String getDefaultDatabaseName() {
        return this.databaseName;
    }

    static final class ClientSessionBoundMongoDbFactory
    implements MongoDbFactory {
        private final com.mongodb.client.ClientSession session;
        private final MongoDbFactory delegate;

        @Override
        public MongoDatabase getDb() throws DataAccessException {
            return this.proxyMongoDatabase(this.delegate.getDb());
        }

        @Override
        public MongoDatabase getDb(String dbName) throws DataAccessException {
            return this.proxyMongoDatabase(this.delegate.getDb(dbName));
        }

        @Override
        public PersistenceExceptionTranslator getExceptionTranslator() {
            return this.delegate.getExceptionTranslator();
        }

        @Override
        public DB getLegacyDb() {
            return this.delegate.getLegacyDb();
        }

        @Override
        public com.mongodb.client.ClientSession getSession(ClientSessionOptions options) {
            return this.delegate.getSession(options);
        }

        @Override
        public MongoDbFactory withSession(com.mongodb.client.ClientSession session) {
            return this.delegate.withSession(session);
        }

        @Override
        public boolean isTransactionActive() {
            return this.session != null && this.session.hasActiveTransaction();
        }

        private MongoDatabase proxyMongoDatabase(MongoDatabase database) {
            return this.createProxyInstance((ClientSession)this.session, database, MongoDatabase.class);
        }

        private MongoDatabase proxyDatabase(ClientSession session, MongoDatabase database) {
            return this.createProxyInstance(session, database, MongoDatabase.class);
        }

        private MongoCollection<?> proxyCollection(ClientSession session, MongoCollection<?> collection) {
            return this.createProxyInstance(session, collection, MongoCollection.class);
        }

        private <T> T createProxyInstance(ClientSession session, T target, Class<T> targetType) {
            ProxyFactory factory = new ProxyFactory();
            factory.setTarget(target);
            factory.setInterfaces(new Class[]{targetType});
            factory.setOpaque(true);
            factory.addAdvice(new SessionAwareMethodInterceptor<MongoDatabase, MongoCollection>(session, target, com.mongodb.client.ClientSession.class, MongoDatabase.class, this::proxyDatabase, MongoCollection.class, this::proxyCollection));
            return targetType.cast(factory.getProxy(target.getClass().getClassLoader()));
        }

        public ClientSessionBoundMongoDbFactory(com.mongodb.client.ClientSession session, MongoDbFactory delegate) {
            this.session = session;
            this.delegate = delegate;
        }

        public com.mongodb.client.ClientSession getSession() {
            return this.session;
        }

        public MongoDbFactory getDelegate() {
            return this.delegate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientSessionBoundMongoDbFactory)) {
                return false;
            }
            ClientSessionBoundMongoDbFactory other = (ClientSessionBoundMongoDbFactory)o;
            com.mongodb.client.ClientSession this$session = this.getSession();
            com.mongodb.client.ClientSession other$session = other.getSession();
            if (this$session == null ? other$session != null : !this$session.equals(other$session)) {
                return false;
            }
            MongoDbFactory this$delegate = this.getDelegate();
            MongoDbFactory other$delegate = other.getDelegate();
            return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            com.mongodb.client.ClientSession $session = this.getSession();
            result = result * 59 + ($session == null ? 43 : $session.hashCode());
            MongoDbFactory $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
            return result;
        }

        public String toString() {
            return "MongoDbFactorySupport.ClientSessionBoundMongoDbFactory(session=" + this.getSession() + ", delegate=" + this.getDelegate() + ")";
        }
    }
}

