/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConvertOperators {
    public static ConvertOperatorFactory valueOf(String fieldReference) {
        return new ConvertOperatorFactory(fieldReference);
    }

    public static ConvertOperatorFactory valueOf(AggregationExpression expression) {
        return new ConvertOperatorFactory(expression);
    }

    public static class ToString
    extends AbstractAggregationExpression {
        private ToString(Object value) {
            super(value);
        }

        public static ToString toString(Object value) {
            return new ToString(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toString";
        }
    }

    public static class ToObjectId
    extends AbstractAggregationExpression {
        private ToObjectId(Object value) {
            super(value);
        }

        public static ToObjectId toObjectId(Object value) {
            return new ToObjectId(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toObjectId";
        }
    }

    public static class ToLong
    extends AbstractAggregationExpression {
        private ToLong(Object value) {
            super(value);
        }

        public static ToLong toLong(Object value) {
            return new ToLong(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toLong";
        }
    }

    public static class ToInt
    extends AbstractAggregationExpression {
        private ToInt(Object value) {
            super(value);
        }

        public static ToInt toInt(Object value) {
            return new ToInt(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toInt";
        }
    }

    public static class ToDouble
    extends AbstractAggregationExpression {
        private ToDouble(Object value) {
            super(value);
        }

        public static ToDouble toDouble(Object value) {
            return new ToDouble(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toDouble";
        }
    }

    public static class ToDecimal
    extends AbstractAggregationExpression {
        private ToDecimal(Object value) {
            super(value);
        }

        public static ToDecimal toDecimal(Object value) {
            return new ToDecimal(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toDecimal";
        }
    }

    public static class ToDate
    extends AbstractAggregationExpression {
        private ToDate(Object value) {
            super(value);
        }

        public static ToDate toDate(Object value) {
            return new ToDate(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toDate";
        }
    }

    public static class ToBool
    extends AbstractAggregationExpression {
        private ToBool(Object value) {
            super(value);
        }

        public static ToBool toBoolean(Object value) {
            return new ToBool(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toBool";
        }
    }

    public static class Convert
    extends AbstractAggregationExpression {
        private Convert(Object value) {
            super(value);
        }

        public static Convert convertValue(Object value) {
            return new Convert(Collections.singletonMap("input", value));
        }

        public static Convert convertValueOf(String fieldReference) {
            return Convert.convertValue(Fields.field(fieldReference));
        }

        public static Convert convertValueOf(AggregationExpression expression) {
            return Convert.convertValue(expression);
        }

        public Convert to(String stringTypeIdentifier) {
            return new Convert(this.append("to", stringTypeIdentifier));
        }

        public Convert to(int numericTypeIdentifier) {
            return new Convert(this.append("to", numericTypeIdentifier));
        }

        public Convert to(JsonSchemaObject.Type type) {
            String typeString = JsonSchemaObject.Type.BOOLEAN.equals(type) ? "bool" : type.value().toString();
            return this.to(typeString);
        }

        public Convert toTypeOf(String fieldReference) {
            return new Convert(this.append("to", Fields.field(fieldReference)));
        }

        public Convert toTypeOf(AggregationExpression expression) {
            return new Convert(this.append("to", expression));
        }

        public Convert onErrorReturn(Object value) {
            return new Convert(this.append("onError", value));
        }

        public Convert onErrorReturnValueOf(String fieldReference) {
            return this.onErrorReturn(Fields.field(fieldReference));
        }

        public Convert onErrorReturnValueOf(AggregationExpression expression) {
            return this.onErrorReturn(expression);
        }

        public Convert onNullReturn(Object value) {
            return new Convert(this.append("onNull", value));
        }

        public Convert onNullReturnValueOf(String fieldReference) {
            return this.onNullReturn(Fields.field(fieldReference));
        }

        public Convert onNullReturnValueOf(AggregationExpression expression) {
            return this.onNullReturn(expression);
        }

        @Override
        protected String getMongoMethod() {
            return "$convert";
        }
    }

    public static class ConvertOperatorFactory {
        @Nullable
        private final String fieldReference;
        @Nullable
        private final AggregationExpression expression;

        public ConvertOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public ConvertOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            this.fieldReference = null;
            this.expression = expression;
        }

        public Convert convertTo(String stringTypeIdentifier) {
            return this.createConvert().to(stringTypeIdentifier);
        }

        public Convert convertTo(int numericTypeIdentifier) {
            return this.createConvert().to(numericTypeIdentifier);
        }

        public Convert convertTo(JsonSchemaObject.Type type) {
            return this.createConvert().to(type);
        }

        public Convert convertToTypeOf(String fieldReference) {
            return this.createConvert().toTypeOf(fieldReference);
        }

        public Convert convertToTypeOf(AggregationExpression expression) {
            return this.createConvert().toTypeOf(expression);
        }

        public ToBool convertToBoolean() {
            return ToBool.toBoolean(this.valueObject());
        }

        public ToDate convertToDate() {
            return ToDate.toDate(this.valueObject());
        }

        public ToDecimal convertToDecimal() {
            return ToDecimal.toDecimal(this.valueObject());
        }

        public ToDouble convertToDouble() {
            return ToDouble.toDouble(this.valueObject());
        }

        public ToInt convertToInt() {
            return ToInt.toInt(this.valueObject());
        }

        public ToLong convertToLong() {
            return ToLong.toLong(this.valueObject());
        }

        public ToObjectId convertToObjectId() {
            return ToObjectId.toObjectId(this.valueObject());
        }

        public ToString convertToString() {
            return ToString.toString(this.valueObject());
        }

        private Convert createConvert() {
            return this.usesFieldRef() ? Convert.convertValueOf(this.fieldReference) : Convert.convertValueOf(this.expression);
        }

        private Object valueObject() {
            return this.usesFieldRef() ? Fields.field(this.fieldReference) : this.expression;
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }
}

