/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClientSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.StreamSupport;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class BsonUtils {
    @Nullable
    public static <T> T get(Bson bson, String key) {
        return (T)BsonUtils.asMap(bson).get(key);
    }

    public static Map<String, Object> asMap(Bson bson) {
        if (bson instanceof Document) {
            return (Document)bson;
        }
        if (bson instanceof BasicDBObject) {
            return (BasicDBObject)bson;
        }
        throw new IllegalArgumentException("o_O what's that? Cannot read values from " + bson.getClass());
    }

    public static void addToMap(Bson bson, String key, @Nullable Object value) {
        if (bson instanceof Document) {
            ((Document)bson).put(key, value);
            return;
        }
        if (bson instanceof DBObject) {
            ((DBObject)bson).put(key, value);
            return;
        }
        throw new IllegalArgumentException("o_O what's that? Cannot add value to " + bson.getClass());
    }

    public static Object toJavaType(BsonValue value) {
        switch (value.getBsonType()) {
            case INT32: {
                return value.asInt32().getValue();
            }
            case INT64: {
                return value.asInt64().getValue();
            }
            case STRING: {
                return value.asString().getValue();
            }
            case DECIMAL128: {
                return value.asDecimal128().doubleValue();
            }
            case DOUBLE: {
                return value.asDouble().getValue();
            }
            case BOOLEAN: {
                return value.asBoolean().getValue();
            }
            case OBJECT_ID: {
                return value.asObjectId().getValue();
            }
            case DB_POINTER: {
                return new DBRef(value.asDBPointer().getNamespace(), (Object)value.asDBPointer().getId());
            }
            case BINARY: {
                return value.asBinary().getData();
            }
            case DATE_TIME: {
                return new Date(value.asDateTime().getValue());
            }
            case SYMBOL: {
                return value.asSymbol().getSymbol();
            }
            case ARRAY: {
                return value.asArray().toArray();
            }
            case DOCUMENT: {
                return Document.parse((String)value.asDocument().toJson());
            }
        }
        return value;
    }

    @Nullable
    public static String toJson(@Nullable Document source) {
        if (source == null) {
            return null;
        }
        try {
            return source.toJson();
        }
        catch (Exception e) {
            return BsonUtils.toJson((Object)source);
        }
    }

    private static String toJson(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        try {
            return value instanceof Document ? ((Document)value).toJson((Encoder)MongoClientSettings.getDefaultCodecRegistry().get(Document.class)) : BsonUtils.serializeValue(value);
        }
        catch (Exception e) {
            if (value instanceof Collection) {
                return BsonUtils.toString((Collection)value);
            }
            if (value instanceof Map) {
                return BsonUtils.toString((Map)value);
            }
            if (ObjectUtils.isArray((Object)value)) {
                return BsonUtils.toString(Arrays.asList(ObjectUtils.toObjectArray((Object)value)));
            }
            throw e instanceof JsonParseException ? (JsonParseException)((Object)e) : new JsonParseException((Throwable)e);
        }
    }

    private static String serializeValue(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        String documentJson = new Document("toBeEncoded", value).toJson();
        return documentJson.substring(documentJson.indexOf(58) + 1, documentJson.length() - 1).trim();
    }

    private static String toString(Map<?, ?> source) {
        return BsonUtils.iterableToDelimitedString(source.entrySet(), "{ ", " }", entry -> String.format("\"%s\" : %s", entry.getKey(), BsonUtils.toJson(entry.getValue())));
    }

    private static String toString(Collection<?> source) {
        return BsonUtils.iterableToDelimitedString(source, "[ ", " ]", BsonUtils::toJson);
    }

    private static <T> String iterableToDelimitedString(Iterable<T> source, String prefix, String suffix, Converter<? super T, String> transformer) {
        StringJoiner joiner = new StringJoiner(", ", prefix, suffix);
        StreamSupport.stream(source.spliterator(), false).map(arg_0 -> transformer.convert(arg_0)).forEach(joiner::add);
        return joiner.toString();
    }
}

