/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.client.result.DeleteResult;
import java.util.List;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.data.util.TypeInformation;

@FunctionalInterface
interface MongoQueryExecution {
    public Object execute(Query var1);

    public static final class DeleteExecution
    implements MongoQueryExecution {
        @NonNull
        private final MongoOperations operations;
        @NonNull
        private final MongoQueryMethod method;

        @Override
        public Object execute(Query query) {
            String collectionName = this.method.getEntityInformation().getCollectionName();
            Class type = this.method.getEntityInformation().getJavaType();
            if (this.method.isCollectionQuery()) {
                return this.operations.findAllAndRemove(query, type, collectionName);
            }
            DeleteResult writeResult = this.operations.remove(query, type, collectionName);
            return writeResult.wasAcknowledged() ? writeResult.getDeletedCount() : 0L;
        }

        public DeleteExecution(@NonNull MongoOperations operations, @NonNull MongoQueryMethod method) {
            if (operations == null) {
                throw new IllegalArgumentException("operations is marked non-null but is null");
            }
            if (method == null) {
                throw new IllegalArgumentException("method is marked non-null but is null");
            }
            this.operations = operations;
            this.method = method;
        }
    }

    public static final class PagingGeoNearExecution
    extends GeoNearExecution {
        private final ExecutableFindOperation.FindWithQuery<?> operation;
        private final ConvertingParameterAccessor accessor;
        private final AbstractMongoQuery mongoQuery;

        PagingGeoNearExecution(ExecutableFindOperation.FindWithQuery<?> operation, MongoQueryMethod method, ConvertingParameterAccessor accessor, AbstractMongoQuery query) {
            super(operation, method, accessor);
            this.accessor = accessor;
            this.operation = operation;
            this.mongoQuery = query;
        }

        @Override
        public Object execute(Query query) {
            GeoResults<Object> geoResults = this.doExecuteQuery(query);
            Page page = PageableExecutionUtils.getPage((List)geoResults.getContent(), (Pageable)this.accessor.getPageable(), () -> {
                Query countQuery = this.mongoQuery.createCountQuery(this.accessor);
                countQuery = this.mongoQuery.applyQueryMetaAttributesWhenPresent(countQuery);
                return this.operation.matching(countQuery).count();
            });
            return new GeoPage(geoResults, this.accessor.getPageable(), page.getTotalElements());
        }
    }

    public static class GeoNearExecution
    implements MongoQueryExecution {
        @NonNull
        private final ExecutableFindOperation.FindWithQuery<?> operation;
        @NonNull
        private final MongoQueryMethod method;
        @NonNull
        private final MongoParameterAccessor accessor;

        @Override
        public Object execute(Query query) {
            GeoResults<Object> results = this.doExecuteQuery(query);
            return GeoNearExecution.isListOfGeoResult(this.method.getReturnType()) ? results.getContent() : results;
        }

        GeoResults<Object> doExecuteQuery(Query query) {
            Point nearLocation = this.accessor.getGeoNearLocation();
            NearQuery nearQuery = NearQuery.near(nearLocation);
            if (query != null) {
                nearQuery.query(query);
            }
            Range<Distance> distances = this.accessor.getDistanceRange();
            distances.getLowerBound().getValue().ifPresent(it -> nearQuery.minDistance((Distance)it).in(it.getMetric()));
            distances.getUpperBound().getValue().ifPresent(it -> nearQuery.maxDistance((Distance)it).in(it.getMetric()));
            Pageable pageable = this.accessor.getPageable();
            nearQuery.with(pageable);
            return this.operation.near(nearQuery).all();
        }

        private static boolean isListOfGeoResult(TypeInformation<?> returnType) {
            if (!returnType.getType().equals(List.class)) {
                return false;
            }
            TypeInformation componentType = returnType.getComponentType();
            return componentType != null && GeoResult.class.equals((Object)componentType.getType());
        }

        public GeoNearExecution(@NonNull ExecutableFindOperation.FindWithQuery<?> operation, @NonNull MongoQueryMethod method, @NonNull MongoParameterAccessor accessor) {
            if (operation == null) {
                throw new IllegalArgumentException("operation is marked non-null but is null");
            }
            if (method == null) {
                throw new IllegalArgumentException("method is marked non-null but is null");
            }
            if (accessor == null) {
                throw new IllegalArgumentException("accessor is marked non-null but is null");
            }
            this.operation = operation;
            this.method = method;
            this.accessor = accessor;
        }
    }

    public static final class PagedExecution
    implements MongoQueryExecution {
        @NonNull
        private final ExecutableFindOperation.FindWithQuery<?> operation;
        @NonNull
        private final Pageable pageable;

        @Override
        public Object execute(Query query) {
            int overallLimit = query.getLimit();
            ExecutableFindOperation.TerminatingFind<?> matching = this.operation.matching(query);
            query.with(this.pageable);
            if (overallLimit != 0 && this.pageable.getOffset() + (long)this.pageable.getPageSize() > (long)overallLimit) {
                query.limit((int)((long)overallLimit - this.pageable.getOffset()));
            }
            return PageableExecutionUtils.getPage(matching.all(), (Pageable)this.pageable, () -> {
                long count = matching.count();
                return overallLimit != 0 ? Math.min(count, (long)overallLimit) : count;
            });
        }

        public PagedExecution(@NonNull ExecutableFindOperation.FindWithQuery<?> operation, @NonNull Pageable pageable) {
            if (operation == null) {
                throw new IllegalArgumentException("operation is marked non-null but is null");
            }
            if (pageable == null) {
                throw new IllegalArgumentException("pageable is marked non-null but is null");
            }
            this.operation = operation;
            this.pageable = pageable;
        }
    }

    public static final class SlicedExecution
    implements MongoQueryExecution {
        @NonNull
        private final ExecutableFindOperation.FindWithQuery<?> find;
        @NonNull
        private final Pageable pageable;

        @Override
        public Object execute(Query query) {
            int pageSize = this.pageable.getPageSize();
            Query modifiedQuery = query.with(this.pageable).limit(pageSize + 1);
            List<?> result = this.find.matching(modifiedQuery).all();
            boolean hasNext = result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, this.pageable, hasNext);
        }

        public SlicedExecution(@NonNull ExecutableFindOperation.FindWithQuery<?> find, @NonNull Pageable pageable) {
            if (find == null) {
                throw new IllegalArgumentException("find is marked non-null but is null");
            }
            if (pageable == null) {
                throw new IllegalArgumentException("pageable is marked non-null but is null");
            }
            this.find = find;
            this.pageable = pageable;
        }
    }
}

