/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DocumentAccessor {
    private final Bson document;

    public DocumentAccessor(Bson document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        if (!(document instanceof Document) && !(document instanceof DBObject)) {
            Assert.isInstanceOf(Document.class, (Object)document, (String)"Given Bson must be a Document or DBObject!");
        }
        this.document = document;
    }

    public void put(MongoPersistentProperty prop, @Nullable Object value) {
        Assert.notNull((Object)prop, (String)"MongoPersistentProperty must not be null!");
        String fieldName = prop.getFieldName();
        if (!fieldName.contains(".")) {
            BsonUtils.addToMap(this.document, fieldName, value);
            return;
        }
        Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
        Bson document = this.document;
        while (parts.hasNext()) {
            String part = parts.next();
            if (parts.hasNext()) {
                document = DocumentAccessor.getOrCreateNestedDocument(part, document);
                continue;
            }
            BsonUtils.addToMap(document, part, value);
        }
    }

    @Nullable
    public Object get(MongoPersistentProperty property) {
        String fieldName = property.getFieldName();
        if (!fieldName.contains(".")) {
            return BsonUtils.asMap(this.document).get(fieldName);
        }
        Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
        Map<String, Object> source = BsonUtils.asMap(this.document);
        Object result = null;
        while (source != null && parts.hasNext()) {
            result = source.get(parts.next());
            if (!parts.hasNext()) continue;
            source = DocumentAccessor.getAsMap(result);
        }
        return result;
    }

    public boolean hasValue(MongoPersistentProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null!");
        String fieldName = property.getFieldName();
        if (!fieldName.contains(".")) {
            if (this.document instanceof Document) {
                return ((Document)this.document).containsKey((Object)fieldName);
            }
            if (this.document instanceof DBObject) {
                return ((DBObject)this.document).containsField(fieldName);
            }
        }
        String[] parts = fieldName.split("\\.");
        Object source = this.document instanceof Document ? (Document)this.document : ((DBObject)this.document).toMap();
        Object result = null;
        for (int i = 1; i < parts.length; ++i) {
            result = source.get(parts[i - 1]);
            if ((source = DocumentAccessor.getAsMap(result)) != null) continue;
            return false;
        }
        return source.containsKey(parts[parts.length - 1]);
    }

    @Nullable
    private static Map<String, Object> getAsMap(Object source) {
        if (source instanceof Document) {
            return (Document)source;
        }
        if (source instanceof BasicDBObject) {
            return (BasicDBObject)source;
        }
        if (source instanceof Map) {
            return (Map)source;
        }
        return null;
    }

    private static Document getOrCreateNestedDocument(String key, Bson source) {
        Object existing = BsonUtils.asMap(source).get(key);
        if (existing instanceof Document) {
            return (Document)existing;
        }
        Document nested = new Document();
        BsonUtils.addToMap(source, key, nested);
        return nested;
    }
}

