/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ConnectionString;
import com.mongodb.WriteConcern;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.net.UnknownHostException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleReactiveMongoDatabaseFactory
implements DisposableBean,
ReactiveMongoDatabaseFactory {
    private final MongoClient mongo;
    private final String databaseName;
    private final boolean mongoInstanceCreated;
    private final PersistenceExceptionTranslator exceptionTranslator;
    @Nullable
    private WriteConcern writeConcern;

    public SimpleReactiveMongoDatabaseFactory(ConnectionString connectionString) throws UnknownHostException {
        this(MongoClients.create((ConnectionString)connectionString), connectionString.getDatabase(), true);
    }

    public SimpleReactiveMongoDatabaseFactory(MongoClient mongoClient, String databaseName) {
        this(mongoClient, databaseName, false);
    }

    private SimpleReactiveMongoDatabaseFactory(MongoClient client, String databaseName, boolean mongoInstanceCreated) {
        Assert.notNull((Object)client, (String)"MongoClient must not be null!");
        Assert.hasText((String)databaseName, (String)"Database name must not be empty!");
        Assert.isTrue((boolean)databaseName.matches("[^/\\\\.$\"\\s]+"), (String)"Database name must not contain slashes, dots, spaces, quotes, or dollar signs!");
        this.mongo = client;
        this.databaseName = databaseName;
        this.mongoInstanceCreated = mongoInstanceCreated;
        this.exceptionTranslator = new MongoExceptionTranslator();
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    @Override
    public MongoDatabase getMongoDatabase() throws DataAccessException {
        return this.getMongoDatabase(this.databaseName);
    }

    @Override
    public MongoDatabase getMongoDatabase(String dbName) throws DataAccessException {
        Assert.hasText((String)dbName, (String)"Database name must not be empty.");
        MongoDatabase db = this.mongo.getDatabase(dbName);
        return this.writeConcern != null ? db.withWriteConcern(this.writeConcern) : db;
    }

    public void destroy() throws Exception {
        if (this.mongoInstanceCreated) {
            this.mongo.close();
        }
    }

    @Override
    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }
}

