/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import org.springframework.data.mongodb.core.geo.Metric;
import org.springframework.data.mongodb.core.geo.Metrics;
import org.springframework.util.ObjectUtils;

public class Distance {
    private final double value;
    private final Metric metric;

    public Distance(double value) {
        this(value, Metrics.NEUTRAL);
    }

    public Distance(double value, Metric metric) {
        this.value = value;
        this.metric = metric == null ? Metrics.NEUTRAL : metric;
    }

    public double getValue() {
        return this.value;
    }

    public double getNormalizedValue() {
        return this.value / this.metric.getMultiplier();
    }

    public Metric getMetric() {
        return this.metric;
    }

    public Distance add(Distance other) {
        double newNormalizedValue = this.getNormalizedValue() + other.getNormalizedValue();
        return new Distance(newNormalizedValue * this.metric.getMultiplier(), this.metric);
    }

    public Distance add(Distance other, Metric metric) {
        double newLeft = this.getNormalizedValue() * metric.getMultiplier();
        double newRight = other.getNormalizedValue() * metric.getMultiplier();
        return new Distance(newLeft + newRight, metric);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Distance that = (Distance)obj;
        return this.value == that.value && ObjectUtils.nullSafeEquals((Object)this.metric, (Object)that.metric);
    }

    public int hashCode() {
        int result = 17;
        result = (int)((long)result + 31L * Double.doubleToLongBits(this.value));
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.metric);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        if (this.metric != Metrics.NEUTRAL) {
            builder.append(" ").append(this.metric.toString());
        }
        return builder.toString();
    }
}

