/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoAction {
    private final String collectionName;
    private final WriteConcern defaultWriteConcern;
    private final Class<?> entityType;
    private final MongoActionOperation mongoActionOperation;
    private final DBObject query;
    private final DBObject document;

    public MongoAction(WriteConcern defaultWriteConcern, MongoActionOperation mongoActionOperation, String collectionName, Class<?> entityType, DBObject document, DBObject query) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        this.defaultWriteConcern = defaultWriteConcern;
        this.mongoActionOperation = mongoActionOperation;
        this.collectionName = collectionName;
        this.entityType = entityType;
        this.query = query;
        this.document = document;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public WriteConcern getDefaultWriteConcern() {
        return this.defaultWriteConcern;
    }

    @Deprecated
    public Class<?> getEntityClass() {
        return this.entityType;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public MongoActionOperation getMongoActionOperation() {
        return this.mongoActionOperation;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public DBObject getDocument() {
        return this.document;
    }
}

