/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.util.Assert;

public class SkipOperation
implements AggregationOperation {
    private final long skipCount;

    public SkipOperation(long skipCount) {
        Assert.isTrue((skipCount >= 0L ? 1 : 0) != 0, (String)"Skip count must not be negative!");
        this.skipCount = skipCount;
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        return new BasicDBObject("$skip", (Object)this.skipCount);
    }
}

